/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service.apt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"oracle.dbtools.common.service.model.Service"})
public class ConfigProcessor
extends AbstractProcessor {
    private final SortedSet<String> services = new TreeSet<String>();
    public static final String SERVICE_PATH = "META-INF/oracle.dbtools.common.services";
    static final String ANNOTATION_TYPE = "oracle.dbtools.common.service.model.Service";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateServices(this.processingEnv.getFiler());
        } else {
            TypeElement service = this.processingEnv.getElementUtils().getTypeElement(ANNOTATION_TYPE);
            this.loadExisting(this.processingEnv.getFiler());
            for (Element element : roundEnv.getElementsAnnotatedWith(service)) {
                TypeElement type = (TypeElement)TypeElement.class.cast(element);
                this.services.add(type.getQualifiedName().toString());
            }
        }
        return true;
    }

    private void generateServices(Filer filer) {
        if (this.services.isEmpty()) {
            return;
        }
        Writer w = null;
        FileObject file = null;
        try {
            file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_PATH, new Element[0]);
            w = file.openWriter();
            for (String service : this.services) {
                w.write(service);
                w.write("\n");
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ConfigProcessor.close(w);
                throw throwable;
            }
        }
        ConfigProcessor.close(w);
    }

    /*
     * Loose catch block
     */
    private void loadExisting(Filer filer) {
        FileObject file = null;
        BufferedReader r = null;
        try {
            String line;
            file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_PATH);
            r = new BufferedReader(new InputStreamReader(file.openInputStream(), "UTF-8"));
            while ((line = r.readLine()) != null) {
                this.services.add(line);
            }
        }
        catch (FileNotFoundException e) {
            ConfigProcessor.close(r);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
            {
                catch (Throwable throwable) {
                    ConfigProcessor.close(r);
                    throw throwable;
                }
            }
        }
        ConfigProcessor.close(r);
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

