/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.EntryImpl;
import oracle.dbtools.common.immutables.impl.SetBuilder;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Ordering;

abstract class CollectionFactory {
    private static Set<?> EMPTY_SET = new TreeSet();
    private static Map<?, ?> EMPTY_MAP = new TreeMap();
    static final int MIN_SIZE = 10;
    private static List<?> EMPTY_LIST = new ArrayList(0);

    private CollectionFactory() {
    }

    static <K, V> ImmutableSet<Map.Entry<K, V>> entrySet(Set<Map.Entry<K, V>> entrySet) {
        SetBuilder immutable = SetBuilder.newInstance(entrySet.size(), Ordering.INSERTION, null);
        for (Map.Entry<K, V> entry : entrySet) {
            immutable.add(EntryImpl.newInstance(entry));
        }
        return immutable.build();
    }

    static <V> Set<V> set(int size, Ordering ordering, Comparator<? super V> comparator) {
        if (size == 0) {
            Set<?> empty = EMPTY_SET;
            return empty;
        }
        switch (ordering) {
            case UNSPECIFIED: {
                return new HashSet(size);
            }
            case SORTED: {
                return new TreeSet<V>(comparator);
            }
        }
        return new LinkedHashSet(size);
    }

    static <V> Set<V> asSet(Iterable<V> elements, Ordering ordering, Comparator<? super V> comparator) {
        int size = Iterables.size(elements);
        Set<? super V> target = CollectionFactory.set(size, ordering, comparator);
        Iterables.add(target, elements);
        return target;
    }

    static <V> List<V> list(int size) {
        if (size == 0) {
            List<?> empty = EMPTY_LIST;
            return empty;
        }
        return new ArrayList(size);
    }

    static <V> List<V> asList(Iterable<V> elements) {
        int size = Iterables.size(elements);
        List<V> target = CollectionFactory.list(size);
        Iterables.add(target, elements);
        return target;
    }

    static <K, V> Map<K, V> map(int size, Ordering ordering, Comparator<? super K> comparator) {
        if (size == 0) {
            Map<?, ?> empty = EMPTY_MAP;
            return empty;
        }
        switch (ordering) {
            case UNSPECIFIED: {
                return new HashMap(size);
            }
            case SORTED: {
                return new TreeMap(comparator);
            }
        }
        return new LinkedHashMap(size);
    }
}

