/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.EdgeFormatter;
import oracle.dbtools.common.graph.Visitor;
import oracle.dbtools.common.util.Transform;

public abstract class TextRenderer<V, E> {
    private final EdgeChecker<V, E> edgeChecker;
    private final EdgeFormatter<V, E> edgeFormatter;
    private final Transform<V, String> vertexFormatter;

    protected TextRenderer(EdgeChecker<V, E> edgeChecker, EdgeFormatter<V, E> edgeFormatter, Transform<V, String> vertexFormatter) {
        this.edgeChecker = edgeChecker;
        this.edgeFormatter = edgeFormatter;
        this.vertexFormatter = vertexFormatter;
    }

    public EdgeChecker<V, E> edgeChecker() {
        return this.edgeChecker;
    }

    public EdgeFormatter<V, E> edgeFormatter() {
        return this.edgeFormatter;
    }

    public final Visitor<V, E> renderer() {
        return this.newInstance();
    }

    public Transform<V, String> vertexFormatter() {
        return this.vertexFormatter;
    }

    protected abstract Visitor<V, E> newInstance();

    protected static abstract class RendererBase<V, E>
    implements Visitor<V, E> {
        protected final EdgeChecker<V, E> edgeChecker;
        protected final EdgeFormatter<V, E> edgeFormatter;
        protected final Transform<V, String> vertexFormatter;

        protected RendererBase(TextRenderer<V, E> renderer) {
            this.edgeChecker = ((TextRenderer)renderer).edgeChecker;
            this.edgeFormatter = ((TextRenderer)renderer).edgeFormatter;
            this.vertexFormatter = ((TextRenderer)renderer).vertexFormatter;
        }

        protected String edgeToString(E value, V destination) {
            if (this.edgeFormatter == null) {
                return value.toString();
            }
            return this.edgeFormatter.apply(value, destination);
        }

        protected String vertexToString(V value) {
            if (this.vertexFormatter == null) {
                return value.toString();
            }
            return this.vertexFormatter.apply(value);
        }

        public abstract String toString();
    }
}

