/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.diagnostics;

import java.util.logging.Level;
import oracle.dbtools.common.diagnostics.DiagnosticContext;
import oracle.dbtools.common.diagnostics.DiagnosticOutput;
import oracle.dbtools.common.diagnostics.DiagnosticPageOutput;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Throwables;

class DiagnosticContextImpl
implements CharSequence,
DiagnosticContext {
    private final DiagnosticOutput outputStatus;
    private final StringBuilder pageOutput = new StringBuilder();
    private final DiagnosticPageOutput pageOutputStatus;
    private static final int CALLER_STACK_DEPTH = 4;
    private final Log log = Log.get(DiagnosticContextImpl.class, 4);

    DiagnosticContextImpl(DiagnosticOutput outputStatus, DiagnosticPageOutput pageOutputStatus) {
        this.outputStatus = outputStatus;
        this.pageOutputStatus = pageOutputStatus;
    }

    @Override
    public char charAt(int index) {
        return this.pageOutput.charAt(index);
    }

    @Override
    public boolean enabled() {
        if (DiagnosticPageOutput.ON == this.pageOutputStatus) {
            return true;
        }
        if (DiagnosticOutput.CONSOLE == this.outputStatus) {
            return true;
        }
        return DiagnosticOutput.LOGGER == this.outputStatus && this.log.isLoggable(Level.FINE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagnosticContextImpl other = (DiagnosticContextImpl)obj;
        if (this.outputStatus != other.outputStatus) {
            return false;
        }
        return this.pageOutputStatus == other.pageOutputStatus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.outputStatus == null ? 0 : this.outputStatus.hashCode());
        result = 31 * result + (this.pageOutputStatus == null ? 0 : this.pageOutputStatus.hashCode());
        return result;
    }

    @Override
    public int length() {
        return this.pageOutput.length();
    }

    @Override
    public void log(CharSequence msg) {
        this._log(msg);
    }

    @Override
    public void log(Throwable t) {
        if (t != null) {
            this._log(Throwables.stackTrace(t));
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.pageOutput.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.pageOutput.toString();
    }

    private void _log(CharSequence msg) {
        if (!NullOrEmpty.nullOrEmpty(msg)) {
            String text = msg.toString().trim();
            switch (this.outputStatus) {
                case OFF: {
                    break;
                }
                case CONSOLE: {
                    this.logToConsole(text);
                    break;
                }
                case LOGGER: {
                    this.logToLogger(text);
                }
            }
            switch (this.pageOutputStatus) {
                case OFF: {
                    break;
                }
                case ON: {
                    this.logToPage(text);
                }
            }
        }
    }

    private void logToConsole(String msg) {
        try {
            this.log.console(msg);
        }
        catch (Throwable t) {
            this.log.fine(t);
        }
    }

    private void logToLogger(String msg) {
        this.log.fine(msg);
    }

    private void logToPage(String text) {
        this.pageOutput.append(text);
        this.pageOutput.append('\n');
    }
}

