/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.builder.CanBuild;
import oracle.dbtools.common.config.AsAssociativeArray;
import oracle.dbtools.common.config.ConfigurationBase;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.plugin.api.conf.Configuration;

public class ConfigurationsBuilder
extends AssociativeArrays.Base<String, Configuration>
implements Configurations,
CanBuild<Configurations> {
    private final Map<String, Configuration> configs = new LinkedHashMap<String, Configuration>();

    private ConfigurationsBuilder() {
    }

    private ConfigurationsBuilder(Configurations existing) {
        for (String name : existing) {
            this.configuration(name, existing.get(name));
        }
    }

    @Override
    public Configurations build() {
        return this;
    }

    public ConfigurationsBuilder configuration(String name, Configuration configuration) {
        this.configs.put(name, configuration);
        return this;
    }

    public ConfigurationsBuilder configuration(String name, String ... valuePairs) {
        AssociativeArray<String, String> properties = AssociativeArrays.asArray(valuePairs);
        return this.configuration(name, properties);
    }

    @Override
    public boolean exists(String name) {
        return this.configs.containsKey(name);
    }

    @Override
    public Configuration get(Object key) {
        return this.get(key.toString());
    }

    @Override
    public Configuration get(String name) {
        return this.configs.get(name);
    }

    @Override
    public Iterator<String> iterator() {
        return this.configs.keySet().iterator();
    }

    @Override
    public int size() {
        return this.configs.size();
    }

    @Override
    public String toString() {
        return this.configs.toString();
    }

    public ConfigurationsBuilder update(String confName, AssociativeArray<String, String> properties) {
        Configuration existing = this.configs.get(confName);
        if (existing == null) {
            return this.configuration(confName, properties);
        }
        return this.configuration(confName, new MergedConfiguration(properties, existing));
    }

    private ConfigurationsBuilder configuration(String name, final AssociativeArray<String, String> properties) {
        this.configuration(name, new ConfigurationBase(){

            @Override
            protected AssociativeArray<String, String> values() {
                return properties;
            }
        });
        return this;
    }

    public static ConfigurationsBuilder builder() {
        return new ConfigurationsBuilder();
    }

    public static ConfigurationsBuilder builder(Configurations existing) {
        return new ConfigurationsBuilder(existing);
    }

    private static final class MergedConfiguration
    extends ConfigurationBase {
        private final AssociativeArray<String, String> existing;
        private final AssociativeArray<String, String> properties;

        private MergedConfiguration(AssociativeArray<String, String> properties, Configuration existing) {
            this.properties = properties;
            this.existing = AsAssociativeArray.asAssociativeArray(existing);
        }

        @Override
        protected AssociativeArray<String, String> values() {
            return AssociativeArrays.merge(this.properties, this.existing);
        }
    }
}

