/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.cache;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.dbtools.common.cache.AssociativeArrayCache;
import oracle.dbtools.common.cache.CacheEntry;
import oracle.dbtools.common.cache.CachePolicy;
import oracle.dbtools.common.cache.CacheStatistics;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Sampler;

class AssociativeArrayCacheImpl<K, V>
extends AssociativeArrays.Base<K, V>
implements AssociativeArrayCache<K, V> {
    private final long created;
    private volatile ConcurrentMap<K, CacheEntry<V>> entries = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final Sampler fullRefreshTimings = new Sampler();
    private final Sampler incrementalRefreshTimings = new Sampler();
    private volatile long lastFullRefresh = 0L;
    private final AssociativeArrayCache.Loader<K, V> loader;
    private final CachePolicy policy;
    private volatile RefreshState refreshState;
    private final Sampler sizings = new Sampler();

    AssociativeArrayCacheImpl(AssociativeArrayCache.Loader<K, V> loader, CachePolicy policy) {
        this.loader = loader;
        this.policy = policy;
        this.created = System.currentTimeMillis();
        this.refreshState = RefreshState.NOT_REFRESHING;
    }

    @Override
    public V get(Object key) {
        this.checkForFullRefresh();
        V value = this._get(key);
        if (value == null) {
            this.incrementalRefresh();
            value = this._get(key);
        }
        return value;
    }

    @Override
    public void invalidate() {
        long now = System.currentTimeMillis();
        this.fullRefresh(now);
    }

    @Override
    public Iterator<K> iterator() {
        this.checkForFullRefresh();
        ConcurrentMap<K, CacheEntry<V>> entries = this.entries;
        if (entries == null) {
            return Iterators.empty();
        }
        return entries.keySet().iterator();
    }

    @Override
    public CachePolicy policy() {
        return this.policy;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public CacheStatistics statistics() {
        return new Statistics();
    }

    private V _get(Object key) {
        CacheEntry value = (CacheEntry)this.entries.get(key);
        if (value != null) {
            return value.get();
        }
        return null;
    }

    private void checkForFullRefresh() {
        long now = System.currentTimeMillis();
        if (now - this.lastFullRefresh > this.policy.fullRefreshInterval()) {
            this.fullRefresh(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullRefresh(long now) {
        if (this.refreshState == RefreshState.NOT_REFRESHING) {
            this.refreshState = RefreshState.FULL_REFRESH;
            try {
                ConcurrentHashMap stored = new ConcurrentHashMap();
                AssociativeArray entries = (AssociativeArray)this.loader.fullLoad();
                for (Object key : entries) {
                    stored.put(key, new CacheEntry(entries.get(key)));
                }
                this.lastFullRefresh = now;
                this.sizings.add(stored.size());
                this.entries = stored;
            }
            finally {
                long elapsed = System.currentTimeMillis() - now;
                this.fullRefreshTimings.add(elapsed);
                this.refreshState = RefreshState.NOT_REFRESHING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalRefresh() {
        if (this.refreshState == RefreshState.NOT_REFRESHING) {
            this.refreshState = RefreshState.INCREMENTAL_REFRESH;
            long now = System.currentTimeMillis();
            try {
                ConcurrentMap stored = this.entries;
                AssociativeArray entries = (AssociativeArray)this.loader.incrementalLoad(this.lastFullRefresh);
                for (Object key : entries) {
                    Object value;
                    CacheEntry existing = stored.putIfAbsent(key, new CacheEntry(value = entries.get(key)));
                    if (existing == null) continue;
                    existing.set(value);
                }
                this.sizings.add(stored.size());
            }
            finally {
                long elapsed = System.currentTimeMillis() - now;
                this.incrementalRefreshTimings.add(elapsed);
                this.refreshState = RefreshState.NOT_REFRESHING;
            }
        }
    }

    private final class Statistics
    implements CacheStatistics {
        private Statistics() {
        }

        @Override
        public long created() {
            return AssociativeArrayCacheImpl.this.created;
        }

        @Override
        public Sampler.Snapshot fullRefreshTimings() {
            return AssociativeArrayCacheImpl.this.fullRefreshTimings.snapshot();
        }

        @Override
        public Sampler.Snapshot incrementalRefreshTimings() {
            return AssociativeArrayCacheImpl.this.incrementalRefreshTimings.snapshot();
        }

        @Override
        public long lastFullRefresh() {
            return AssociativeArrayCacheImpl.this.lastFullRefresh;
        }

        @Override
        public long nextFullRefreshTime() {
            return AssociativeArrayCacheImpl.this.lastFullRefresh + AssociativeArrayCacheImpl.this.policy().fullRefreshInterval();
        }

        @Override
        public Sampler.Snapshot sizings() {
            return AssociativeArrayCacheImpl.this.sizings.snapshot();
        }
    }

    private static enum RefreshState {
        FULL_REFRESH,
        INCREMENTAL_REFRESH,
        NOT_REFRESHING;

    }
}

