/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.buffers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.buffers.MemoryHandle;
import oracle.dbtools.common.buffers.StreamBuffer;
import oracle.dbtools.common.util.ResourceTracker;

class MemoryBuffer
implements StreamBuffer {
    private ByteArrayOutputStream bytes = null;

    MemoryBuffer() {
    }

    @Override
    public BufferHandle acquire() {
        if (this.bytes == null) {
            throw new IllegalStateException("No buffer yet created");
        }
        return new MemoryHandle(this.bytes.toByteArray());
    }

    @Override
    public OutputStream open() throws IOException {
        this.bytes = new ByteArrayOutputStream();
        return ResourceTracker.track(this.bytes);
    }

    public String toString() {
        if (this.bytes != null) {
            return "" + this.bytes.size();
        }
        return "0";
    }

    byte[] bytes() {
        return this.bytes.toByteArray();
    }
}

