/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.AWTEvent;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;

public class ViewBuilderEvent
extends AWTEvent {
    private static final int EVENT_START = 2000;
    public static final int TABLE_ADDING = 2000;
    public static final int TABLE_ADDED = 2001;
    public static final int TABLE_REMOVING = 2002;
    public static final int TABLE_REMOVED = 2003;
    public static final int RELATIONSHIP_ADDING = 2004;
    public static final int RELATIONSHIP_ADDED = 2005;
    public static final int RELATIONSHIP_REMOVING = 2006;
    public static final int RELATIONSHIP_REMOVED = 2007;
    public static final int OUTERJOIN_ADDED = 2008;
    public static final int OUTERJOIN_REMOVED = 2009;
    private Table _table;
    private Relationship _join;
    private OuterJoin _outerJoin;

    public ViewBuilderEvent(ViewBuilder source, int id) {
        super(source, id);
    }

    public ViewBuilderEvent(ViewBuilder source, int id, Table table) {
        super(source, id);
        this._table = table;
    }

    public ViewBuilderEvent(ViewBuilder source, int id, Relationship relationship) {
        super(source, id);
        this._join = relationship;
    }

    public ViewBuilderEvent(ViewBuilder source, int id, OuterJoin outerJoin) {
        super(source, id);
        this._outerJoin = outerJoin;
    }

    public ViewBuilder getViewBuilder() {
        return (ViewBuilder)this.getSource();
    }

    public Table getTable() {
        return this._table;
    }

    public Relationship getRelationship() {
        return this._join;
    }

    public OuterJoin getOuterJoin() {
        return this._outerJoin;
    }

    public String toString() {
        return "ViewBuilderEvent: " + this._getIDString(this.getID());
    }

    private String _getIDString(int id) {
        String s = null;
        switch (id) {
            case 2000: {
                s = "adding table: " + this.getTable().getName();
                break;
            }
            case 2001: {
                s = "added table: " + this.getTable().getName();
                break;
            }
            case 2002: {
                s = "removing table: " + this.getTable().getName();
                break;
            }
            case 2003: {
                s = "removed table: " + this.getTable().getName();
                break;
            }
            case 2004: {
                s = "adding relationship " + this.getRelationship().getName();
                break;
            }
            case 2005: {
                s = "added relationship " + this.getRelationship().getName();
                break;
            }
            case 2006: {
                s = "removing relationship " + this.getRelationship().getName();
                break;
            }
            case 2007: {
                s = "removed relationship " + this.getRelationship().getName();
                break;
            }
            case 2008: {
                s = "added outerjoin " + this.getOuterJoin().getSource().getName() + " to " + this.getOuterJoin().getDestination().getName();
                break;
            }
            case 2009: {
                s = "removed outerjoin " + this.getOuterJoin().getSource().getName() + " to " + this.getOuterJoin().getDestination().getName();
            }
        }
        return s;
    }
}

