/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.scrolling;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;

class ScrollAreaLayout
implements LayoutManager2 {
    public static final String CENTER = "center";
    public static final String EAST = "east";
    private Component _center;
    private Component _east;

    ScrollAreaLayout() {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
        if (this._center == comp) {
            this._center = null;
        } else if (this._east == comp) {
            this._east = null;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension temp;
        Dimension d = new Dimension();
        if (this._center != null) {
            temp = this._center.getPreferredSize();
            d.width += temp.width;
            if (temp.height > d.height) {
                d.height = temp.height;
            }
        }
        if (this._east != null) {
            temp = this._east.getPreferredSize();
            d.width += temp.width;
            if (temp.height > d.height) {
                d.height = temp.height;
            }
        }
        return d;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension temp;
        Dimension d = new Dimension();
        if (this._center != null) {
            temp = this._center.getMinimumSize();
            d.width += temp.width;
            if (temp.height > d.height) {
                d.height = temp.height;
            }
        }
        if (this._east != null) {
            temp = this._east.getMinimumSize();
            d.width += temp.width;
            if (temp.height > d.height) {
                d.height = temp.height;
            }
        }
        return d;
    }

    public void layoutContainer(Container parent) {
        int y;
        int x;
        Dimension d;
        Component child;
        Dimension size = parent.getSize();
        if (this._center != null) {
            child = this._center;
            d = child.getPreferredSize();
            if (d.width > size.width) {
                d.width = size.width;
            }
            if (d.height > size.height) {
                d.height = size.height;
            }
            x = (size.width - d.width) / 2;
            y = (size.height - d.height) / 2;
            child.setBounds(x, y, d.width, d.height);
        }
        if (this._east != null) {
            child = this._east;
            d = child.getPreferredSize();
            if (d.width > size.width) {
                d.width = size.width;
            }
            if (d.height > size.height) {
                d.height = size.height;
            }
            x = size.width - d.width;
            y = (size.height - d.height) / 2;
            child.setBounds(x, y, d.width, d.height);
        }
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (CENTER.equals(constraints)) {
            this._center = comp;
        } else if (EAST.equals(constraints)) {
            this._east = comp;
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

