/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.dbUI.graph.jle.JLECaptionTile;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;

class TitleBar
extends JPanel {
    private JLEWindow _component;
    private JLabel _titleLabel;
    private JLabel _iconLabel;
    private CaptionComp _captionTile;
    private JPanel _buttonPanel;
    private JButton _minimizeButton;
    private JButton _restoreButton;
    private JButton _closeButton;
    private static final String _ACTIVE = "paintActive";
    private boolean _armed;
    private static final int _MINIMUM_WIDTH = 130;
    private static final int _CAPTION_MIN_WIDTH = 45;
    private static KeyStroke _sCloseShortcut;
    private static final String _RESTORE_KEY = "RESTORE";
    private static final String _MOVE_KEY = "MOVE";
    private static final String _RESIZE_KEY = "RESIZE";
    private static final String _MINIMIZE_KEY = "MINIMIZE";
    private static final String _CLOSE_KEY = "CLOSE";
    private static final Painter _CAPTION_FILL;
    private static Painter _sCloseIcon;
    private static Painter _sMinimizeIcon;
    private static Painter _sRestoreIcon;
    private static Painter _sLightPainter;
    private static Painter _sDarkPainter;
    private Image _image;
    private Color _background;
    private Color _foreground;
    private boolean _tooltipDefaulted = true;
    private String _tooltipString;
    private boolean _autoDisplay;
    private static final int _DEFAULT_HEIGHT = 20;

    public TitleBar(JLEWindow component) {
        this._component = component;
        this._createComponents();
        this.__updateButtons();
        this._updateCaptionFill();
        this._addListeners();
    }

    public void setPainter(Painter p) {
        this._captionTile.setPainter(p);
    }

    public Painter getPainter() {
        return this._captionTile.getPainter();
    }

    public void setTitleBackground(Color c) {
        this._background = c;
        this.setBackground(c);
    }

    public void setTitleForeground(Color c) {
        this._foreground = c;
        this.setForeground(c);
    }

    public Color getBackground() {
        UIDefaults defaults;
        Color bg;
        if (this._component != null && (bg = this._getBackground(defaults = UIManager.getDefaults(), this.isActive())) != null) {
            return bg;
        }
        return super.getBackground();
    }

    public Color getForeground() {
        UIDefaults defaults;
        Color fg;
        if (this._component != null && (fg = this._getForeground(defaults = UIManager.getDefaults(), this.isActive())) != null) {
            return fg;
        }
        return super.getForeground();
    }

    public void setClosable(boolean closable) {
        this._closeButton.setVisible(closable);
    }

    public boolean isClosable() {
        return this._closeButton.isVisible();
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setArmed(boolean armed) {
        if (armed != this._armed) {
            this._armed = armed;
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        Dimension minSize = super.getMinimumSize();
        minSize.width = 130;
        return minSize;
    }

    public Dimension getMaximumSize() {
        Dimension maxSize = super.getMaximumSize();
        Dimension prefSize = this.getPreferredSize();
        maxSize.height = prefSize.height;
        return maxSize;
    }

    public void setTitle(String title) {
        this._titleLabel.setText(title);
        this.invalidate();
        this.repaint();
    }

    public void setToolTipText(String title) {
        this._tooltipDefaulted = title == null;
        this._tooltipString = title;
        this._titleLabel.setToolTipText(title);
    }

    public boolean isToolTipDefaulted() {
        return this._tooltipDefaulted;
    }

    public String getToolTipText() {
        return this._tooltipString;
    }

    public void setAutoDisplay(boolean autoDisplay) {
        if (this._autoDisplay != autoDisplay) {
            this._autoDisplay = autoDisplay;
            if (autoDisplay) {
                if (this.isToolTipDefaulted()) {
                    this._titleLabel.setToolTipText(this.getTitle());
                }
            } else if (this.isToolTipDefaulted()) {
                this._titleLabel.setToolTipText(null);
            }
        }
    }

    public boolean getAutoDisplay() {
        return this._autoDisplay;
    }

    public String getTitle() {
        return this._titleLabel.getText();
    }

    public void setSelected(boolean selected) {
        this._updateButtonActiveState(selected);
    }

    public boolean isActive() {
        return this._component.isSelected();
    }

    private void _createComponents() {
        this._titleLabel = new JLabel(){
            private Font _font;

            public void setToolTipText(String o) {
                super.setToolTipText(o);
                ToolTipManager.sharedInstance().unregisterComponent(TitleBar.this._titleLabel);
            }

            public Font getFont() {
                Font f = super.getFont();
                if (f != null && (this._font == null || f.getName() != this._font.getName() || f.getSize() != this._font.getSize())) {
                    this._font = new Font(f.getName(), 1, f.getSize());
                }
                return this._font;
            }

            public Color getForeground() {
                if (TitleBar.this != null) {
                    return TitleBar.this.getForeground();
                }
                return super.getForeground();
            }
        };
        this._iconLabel = new JLabel();
        this._captionTile = new CaptionComp();
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new FlowLayout(0, 2, 0));
        this._buttonPanel.setOpaque(false);
        this._minimizeButton = this._createButton("InternalFrame.iconifyIcon");
        this._restoreButton = this._createButton("InternalFrame.minimizeIcon");
        this._closeButton = this._createButton("InternalFrame.closeIcon");
        this._updateButtonActiveState(this.isActive());
        this._buttonPanel.add(this._minimizeButton);
        this._buttonPanel.add(this._restoreButton);
        this._buttonPanel.add(this._closeButton);
        this.setLayout(new TitleBarLayout());
        this.add(this._titleLabel);
        this.add(this._iconLabel);
        this.add((Component)((Object)this._captionTile));
        this.add(this._buttonPanel);
    }

    private Color _getBackground(UIDefaults defaults, boolean active) {
        return this._background != null ? this._background : (active ? defaults.getColor("InternalFrame.activeTitleBackground") : defaults.getColor("InternalFrame.inactiveTitleBackground"));
    }

    private Color _getForeground(UIDefaults defaults, boolean active) {
        return this._foreground != null ? this._foreground : (active ? defaults.getColor("InternalFrame.activeTitleForeground") : defaults.getColor("InternalFrame.inactiveTitleForeground"));
    }

    void __updateButtons() {
        JLEWindow component = this._component;
        boolean minimized = component.isMinimized();
        this._restoreButton.setVisible(minimized);
        this._minimizeButton.setVisible(!minimized);
    }

    private void _updateCaptionFill() {
        JLEWindow component = this._component;
        Painter captionFill = _CAPTION_FILL;
        if (captionFill != this._captionTile.getPainter()) {
            this._captionTile.setPainter(captionFill);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._updateEnabledState();
    }

    public void setImage(Image frameIcon) {
        this._image = frameIcon;
        this._iconLabel.setIcon(new ImageIcon(frameIcon));
    }

    public Image getImage() {
        return this._image;
    }

    private void _addListeners() {
        JLEWindow component = this._component;
        ActionHandler actionHandler = new ActionHandler();
        this._titleLabel.addMouseListener(actionHandler);
        this._iconLabel.addMouseListener(actionHandler);
        this._captionTile.addMouseListener(actionHandler);
        this.addMouseListener(actionHandler);
        this._minimizeButton.addMouseListener(actionHandler);
        this._restoreButton.addMouseListener(actionHandler);
        this._closeButton.addMouseListener(actionHandler);
    }

    private void _updateEnabledState() {
        JLEWindow component = this._component;
        boolean enabled = component.isEnabled();
        this._titleLabel.setEnabled(enabled);
        this._iconLabel.setEnabled(enabled);
        this._minimizeButton.setEnabled(enabled);
        this._closeButton.setEnabled(enabled);
        this._restoreButton.setEnabled(enabled);
    }

    private JButton _createButton(String iconName) {
        UIDefaults defaults = UIManager.getDefaults();
        Icon icon = defaults.getIcon(iconName);
        TitleBarButton button = new TitleBarButton(icon);
        return button;
    }

    private void _updateButtonActiveState(boolean active) {
        Boolean paintActive = active ? Boolean.TRUE : Boolean.FALSE;
        this._minimizeButton.putClientProperty(_ACTIVE, paintActive);
        this._closeButton.putClientProperty(_ACTIVE, paintActive);
        this._restoreButton.putClientProperty(_ACTIVE, paintActive);
    }

    static KeyStroke __getCloseShortcut() {
        if (_sCloseShortcut == null) {
            _sCloseShortcut = KeyStroke.getKeyStroke(115, 2);
        }
        return _sCloseShortcut;
    }

    private static Painter _createFill(Painter tile) {
        return new AndOrStatePainterSwitcher((Painter)new FixedBorderPainter((Painter)new FixedAlignmentPainter(tile, 0.0f, 0.5f), 0, 8, 0, 0), (Painter)NullPainter.getPainter(), 4, 0, 0, 0);
    }

    static {
        _CAPTION_FILL = TitleBar._createFill(JLECaptionTile.getPainter());
    }

    private class TitleBarLayout
    implements LayoutManager2 {
        private TitleBarLayout() {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void invalidateLayout(Container target) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this._getSize(1);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this._getSize(0);
        }

        public Dimension maximumLayoutSize(Container target) {
            return this._getSize(2);
        }

        private Dimension _getSize(int which) {
            int height = 20;
            int width = 0;
            switch (which) {
                case 0: {
                    Dimension d;
                    width += 5;
                    if (TitleBar.this._iconLabel.getIcon() != null) {
                        d = TitleBar.this._iconLabel.getMinimumSize();
                        width += d.width + 5;
                        if (d.height > height) {
                            height = d.height;
                        }
                    }
                    if (TitleBar.this._titleLabel.getText() != null) {
                        d = TitleBar.this._titleLabel.getMinimumSize();
                        width += d.width + 5;
                        if (d.height > height) {
                            height = d.height;
                        }
                    }
                    width += 50;
                    d = TitleBar.this._buttonPanel.getMinimumSize();
                    width += d.width + 5;
                    if (d.height <= height) break;
                    height = d.height;
                    break;
                }
                case 1: {
                    Dimension d;
                    width += 5;
                    if (TitleBar.this._iconLabel.getIcon() != null) {
                        d = TitleBar.this._iconLabel.getPreferredSize();
                        width += d.width + 5;
                        if (d.height > height) {
                            height = d.height;
                        }
                    }
                    if (TitleBar.this._titleLabel.getText() != null) {
                        d = TitleBar.this._titleLabel.getPreferredSize();
                        width += d.width + 5;
                        if (d.height > height) {
                            height = d.height;
                        }
                    }
                    width += 50;
                    d = TitleBar.this._buttonPanel.getPreferredSize();
                    width += d.width + 5;
                    if (d.height <= height) break;
                    height = d.height;
                    break;
                }
                case 2: {
                    Dimension d;
                    width += 5;
                    if (TitleBar.this._iconLabel.getIcon() != null) {
                        d = TitleBar.this._iconLabel.getMaximumSize();
                        width += d.width + 5;
                        if (d.height > height) {
                            height = d.height;
                        }
                    }
                    if (TitleBar.this._titleLabel.getText() != null) {
                        d = TitleBar.this._titleLabel.getMaximumSize();
                        width += d.width + 5;
                        if (d.height > height) {
                            height = d.height;
                        }
                    }
                    width += 50;
                    d = TitleBar.this._buttonPanel.getMaximumSize();
                    width += d.width + 5;
                    if (d.height <= height) break;
                    height = d.height;
                }
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            Insets i = parent.getInsets();
            Dimension temp = new Dimension(d.width, d.height);
            boolean l2r = true;
            int x = 5;
            if (i != null) {
                x += i.left;
            }
            int right = d.width - 5;
            if (i != null) {
                right -= i.left + i.right;
            }
            if (TitleBar.this._iconLabel.getIcon() != null) {
                temp = TitleBar.this._iconLabel.getPreferredSize();
                if (l2r) {
                    TitleBar.this._iconLabel.setBounds(x, (d.height - temp.height) / 2, temp.width, temp.height);
                    x += temp.width + 5;
                } else {
                    TitleBar.this._iconLabel.setBounds(right - temp.width, (d.height - temp.height) / 2, temp.width, temp.height);
                    right -= temp.width + 5;
                }
            }
            temp = TitleBar.this._buttonPanel.getPreferredSize();
            if (l2r) {
                TitleBar.this._buttonPanel.setBounds(right - temp.width, (d.height - temp.height) / 2, d.width, temp.height);
                right -= temp.width + 5;
            } else {
                TitleBar.this._buttonPanel.setBounds(x, (d.height - temp.height) / 2, d.width, temp.height);
                x += temp.width + 5;
            }
            if (TitleBar.this._titleLabel.getText() != null) {
                temp = TitleBar.this._titleLabel.getPreferredSize();
                if (x + temp.width + 45 + 5 > right) {
                    temp.width = right - x - 45 - 5;
                    if (TitleBar.this._tooltipDefaulted) {
                        TitleBar.this._titleLabel.setToolTipText(TitleBar.this._titleLabel.getText());
                    }
                }
                if (l2r) {
                    TitleBar.this._titleLabel.setBounds(x, (d.height - temp.height) / 2, temp.width, temp.height);
                    x += temp.width + 5;
                } else {
                    TitleBar.this._titleLabel.setBounds(right - temp.width, (d.height - temp.height) / 2, temp.width, temp.height);
                    right -= temp.width + 5;
                }
            }
            int y = i == null ? 0 : i.top;
            TitleBar.this._captionTile.setBounds(x, y, right - x, d.height);
        }
    }

    private class CaptionComp
    extends PainterComponent {
        private CaptionComp() {
        }

        public Dimension getMinimumSize() {
            Painter fill = this.getPainter();
            Dimension minSize = super.getMinimumSize();
            minSize.height = fill.getMinimumSize((PaintContext)this.getPaintContext()).height;
            if (minSize.width < 45) {
                minSize.width = 45;
            }
            return minSize;
        }

        protected int getPaintState() {
            int state = super.getPaintState();
            if (TitleBar.this.isArmed()) {
                state |= 2;
            }
            if (TitleBar.this.isActive()) {
                state |= 0x20;
            }
            return state;
        }
    }

    private class ActionHandler
    extends MouseAdapter {
        private ActionHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            JLEWindow component = TitleBar.this._component;
            if (!component.isEnabled() || !SwingUtilities.isLeftMouseButton(evt)) {
                return;
            }
            Object item = evt.getSource();
            if (item == TitleBar.this._minimizeButton) {
                component.setMinimized(true);
            } else if (item == TitleBar.this._restoreButton) {
                if (component.isMinimized()) {
                    component.setMinimized(false);
                }
            } else if (item == TitleBar.this._closeButton) {
                component.close();
            } else if (evt.getClickCount() % 2 == 0 && component.isMinimized()) {
                component.setMinimized(false);
            }
            if (item == TitleBar.this._captionTile || item == TitleBar.this._titleLabel) {
                TitleBar.this.setArmed(true);
            }
        }

        public void mouseReleased(MouseEvent me) {
            JLEWindow component = TitleBar.this._component;
            if (!component.isEnabled() || !SwingUtilities.isLeftMouseButton(me)) {
                return;
            }
            Object src = me.getSource();
            if (src == TitleBar.this._captionTile || src == TitleBar.this._titleLabel) {
                TitleBar.this.setArmed(false);
            }
        }
    }

    private class TitleBarButton
    extends JButton {
        public TitleBarButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setContentAreaFilled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

