/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.dbUI.graph.ClassComparator;
import oracle.bali.dbUI.graph.Graph;
import oracle.bali.dbUI.graph.GridFocusPainter;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeAutoScroller;
import oracle.bali.dbUI.graph.NodeDataSource;
import oracle.bali.dbUI.graph.NodeToolTipClient;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.PortAppearanceProvider;
import oracle.bali.dbUI.graph.PortComparator;
import oracle.bali.dbUI.graph.SortInputHandler;
import oracle.bali.dbUI.graph.scrolling.ScrollArea;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.grid.AbstractAppearanceManager;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.layout.MaximumBorderLayout;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.BooleanComparator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;

public class NodeComponent
extends LWComponent
implements Accessible {
    public static final String PROPERTY_PORT_LOCATION = "portLocation";
    public static final String PROPERTY_PORT_SELECTION_COUNT = "portSelectionCount";
    public static final String PROPERTY_NODE_EXPANDED = "nodeExpanded";
    public static final String PROPERTY_SORTED_COLUMN = "sortedColumn";
    public static final String COMMAND_PORT_DOUBLE_CLICK = "NodeComponent.portDoubleClick";
    public static final String COMMAND_PORT_SINGLE_CLICK = "NodeComponent.portSingleClick";
    public static final int COLUMN_TARGETABLE = 1;
    public static final int COLUMN_KEY = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_DATATYPE = 4;
    public static final int COLUMN_SOURCEABLE = 5;
    public static final int DEFAULT_COLUMN_COUNT = 6;
    private static Image _sIMAGE_KEY = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/key.gif");
    private static Image _sIMAGE_SOURCEABLE = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/port_sourceable.gif");
    private static Image _sIMAGE_TARGETABLE = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/port_targetable.gif");
    private static Image _sIMAGE_SOURCED = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/port_sourced.gif");
    private static Image _sIMAGE_TARGETED = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/port_targeted.gif");
    private static Image _sIMAGE_NUMBER;
    private static Image _sIMAGE_DATE;
    private static Image _sIMAGE_STRING;
    private static Image _sIMAGE_NODE_SOURCEABLE;
    private static Image _sIMAGE_NODE_TARGETABLE;
    private static Image _sIMAGE_NODE_SOURCED;
    private static Image _sIMAGE_NODE_TARGETED;
    private static Icon _sIMAGE_EXPANDED;
    private static Icon _sIMAGE_COLLAPSED;
    private static final String _GRAPH_BUNDLE = "oracle.bali.dbUI.resource.GraphBundle";
    private static final String _KEY_KEY = "NODECOMPONENT.KEY";
    private static final String _KEY_TARGETABLE = "NODECOMPONENT.TARGETABLE";
    private static final String _KEY_SOURCEABLE = "NODECOMPONENT.SOURCEABLE";
    private static final String _KEY_DATATYPE = "NODECOMPONENT.DATATYPE";
    private static final String _KEY_COLUMN_NAME = "NODECOMPONENT.COLUMN_NAME";
    private static final String _KEY_KEY_DESC = "NODECOMPONENT.KEY_DESC";
    private static final String _KEY_TARGETABLE_DESC = "NODECOMPONENT.TARGETABLE_DESC";
    private static final String _KEY_SOURCEABLE_DESC = "NODECOMPONENT.SOURCEABLE_DESC";
    private static final String _KEY_DATATYPE_DESC = "NODECOMPONENT.DATATYPE_DESC";
    private static final String _KEY_COLUMN_NAME_DESC = "NODECOMPONENT.COLUMN_NAME_DESC";
    private static final String _KEY_S_P = "NODECOMPONENT.S_P";
    private static final String _KEY_S = "NODECOMPONENT.S";
    private static final String _KEY_P = "NODECOMPONENT.P";
    private static final String _KEY_NONE = "NODECOMPONENT.NONE";
    private static final int _DEFAULT_NAME_WIDTH = 150;
    private static final int _IMAGE_WIDTH = 18;
    private static final int _SOURCEABLE_IMAGE_WIDTH = 20;
    static final int _HIDDEN_COLUMN = 0;
    private SpreadTable _spreadTable;
    private ScrollArea _scrollBox;
    private Node _node;
    private Cell _focusCell;
    private Listener _listener = new Listener();
    private PortAppearanceProvider _portAppearanceProvider;
    private Port _targetPort;
    private Graph _graph;
    private SortInputHandler _sorter;
    private ListenerManager _actionListeners;
    private boolean _createMode = false;
    private Hashtable _expansionCache;

    public NodeComponent() {
        this(null);
    }

    public NodeComponent(Node node) {
        this(node, null);
    }

    public NodeComponent(Node node, Graph graph) {
        DBUILookAndFeel laf = DBUILookAndFeel.getLookAndFeel();
        NodeDataSource ds = new NodeDataSource(this);
        ArrayOneDModel hds = new ArrayOneDModel(6);
        this._spreadTable = new _Table((TwoDModel)ds, (OneDModel)hds, null);
        this._spreadTable.setColumnHeaderHeight(10);
        Header h = this._spreadTable.getColumnHeader();
        h.setCanMoveItems(false);
        h.setCanResizeItems(false);
        SortInputHandler sorter = new SortInputHandler(ds);
        h.setHeaderKeyHandler((HeaderKeyHandler)sorter);
        h.setItemInputHandler((HeaderItemInputHandler)sorter);
        this._sorter = sorter;
        Grid grid = this._spreadTable.getGrid();
        grid.setAppearanceManager((AppearanceManager)new AM());
        grid.setVerticalSeparatorsVisible(false);
        GridSelectionManager selection = GeneralGridSelectionManager.createSingleRowSelectionManager();
        grid.setGridSelectionManager(selection);
        grid.addPropertyChangeListener((PropertyChangeListener)this._listener);
        grid.setFill(laf.getBackgroundPainter((JComponent)((Object)this)));
        grid.setDefaultInputHandler((CellInputHandler)new Handler(null));
        grid.setToolTipManager((GridToolTipManager)new NodeToolTipClient());
        this._spreadTable.setColumnVisible(0, false);
        this._spreadTable.setBorder(null);
        FixedAlignmentPainter imagePainter = new FixedAlignmentPainter((Painter)new ImagePainter(PaintContext.IMAGE_KEY, 0));
        this._spreadTable.setColumnWidth(1, 18);
        grid.setColumnPainter(1, (Painter)imagePainter);
        this._spreadTable.setColumnWidth(2, 18);
        grid.setColumnPainter(2, (Painter)imagePainter);
        this._spreadTable.setColumnWidth(3, 150);
        this._spreadTable.setColumnWidth(4, 18);
        grid.setColumnPainter(4, (Painter)imagePainter);
        this._spreadTable.setColumnWidth(5, 20);
        grid.setColumnPainter(5, (Painter)imagePainter);
        this._scrollBox = new ScrollArea(this._spreadTable);
        this._scrollBox.addVAdjustmentListener(this._listener);
        this.setLayout((LayoutManager)new MaximumBorderLayout());
        this.add("Center", (Component)((Object)this._scrollBox));
        this.setNode(node);
        this.setGraph(graph);
        this.updateUI(NodeComponent.class);
        this.getSpreadTable().setBorder(null);
        this.getSpreadTable().getGrid().setBorder(null);
        this.getSpreadTable().getGrid().setOverlayBorderVisible(false);
        this.getSpreadTable().getColumnHeader().setFirstEdge(false);
        this.getSpreadTable().getColumnHeader().setBorder(null);
    }

    public void setCreateMode(boolean createMode) {
        if (this._createMode != createMode) {
            this._createMode = createMode;
            NodeDataSource ds = this._getDataSource();
            if (createMode) {
                ds.setNode(null);
            } else {
                ds.setNode(this.getNode());
                if (this._expansionCache != null) {
                    Enumeration keys = this._expansionCache.keys();
                    if (keys != null) {
                        while (keys.hasMoreElements()) {
                            Node n = (Node)keys.nextElement();
                            Object o = this._expansionCache.get(n);
                            boolean expanded = Boolean.TRUE.equals(o);
                            ds.setNodeExpanded(n, expanded);
                        }
                    }
                    this._expansionCache.clear();
                }
                this._expansionCache = null;
                this.__invalidate();
                this.__updateUI();
                this.locationChanged();
            }
        }
    }

    public boolean isCreateMode() {
        return this._createMode;
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        Node oldNode = this._node;
        if (node != oldNode) {
            this._node = node;
            if (!this.isCreateMode()) {
                this._getDataSource().setNode(this._node);
                this.__updateUI();
            }
        }
    }

    public Graph getGraph() {
        return this._graph;
    }

    public void setGraph(Graph graph) {
        Graph oldGraph = this._graph;
        if (graph != oldGraph) {
            if (oldGraph != null) {
                oldGraph.removePropertyChangeListener(this._listener);
            }
            this._graph = graph;
            if (this._graph != null) {
                this._graph.addPropertyChangeListener(this._listener);
            }
            this.__updateUI();
        }
    }

    public void setDropTargetPort(Port p) {
        if (this._targetPort != p) {
            Grid g = this._getGrid();
            Port oldPort = this._targetPort;
            this._targetPort = null;
            if (oldPort != null) {
                g.paintRow(this.getPortIndex(oldPort));
            }
            if (p != null) {
                int index = this.getPortIndex(p);
                if (p.isTargetable()) {
                    this._targetPort = p;
                    if (this._targetPort != null) {
                        g.paintRow(index);
                    }
                }
            }
            this.autoScroll(p);
        } else if (this._targetPort != null) {
            this.autoScroll(this._targetPort);
        }
    }

    public Port getDropTargetPort() {
        return this._targetPort;
    }

    public void autoScroll(Port port) {
        this._checkScroller(this.getPortIndex(port));
    }

    public void addActionListener(ActionListener listener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)listener);
        }
    }

    public int getPortLocation(Port port) {
        int index = this._getPortIndex(port);
        if (index == -1) {
            for (Node node = port.getParent(); node != this.getNode() && node != null && (this.isNodeExpanded(node) || (index = this._getPortIndex(node)) == -1); node = node.getParent()) {
            }
            if (index == -1) {
                return -1;
            }
        }
        Grid grid = this._getGrid();
        int y = grid.getRowPosition(index) + this._getGridOffset();
        Point p = grid.getCanvasOrigin();
        Dimension d = this.getSize();
        if ((y += p.y) < 0) {
            y = 0;
        } else if (d.height < 0) {
            y = 0;
        } else if (y >= d.height) {
            y = d.height;
        } else if ((y += grid.getRowHeight(index) / 2) > d.height) {
            y = d.height;
        }
        return y;
    }

    public Port getPortAt(int y) {
        Grid grid = this._getGrid();
        int origin = this._getGridOffset();
        if (y < origin) {
            return null;
        }
        int cy = grid.getCanvasOriginY();
        y -= cy + origin;
        cy = -cy;
        int innerHt = grid.getInnerHeight();
        if (y < cy || y > cy + innerHt) {
            return null;
        }
        int index = grid.getRowAt(y);
        if (index == -1) {
            return null;
        }
        return this.getPort(index);
    }

    public Port getPort(int index) {
        TwoDModel ds = this._getGrid().getModel();
        if (index < 0 || index >= ds.getRowCount()) {
            return null;
        }
        return (Port)ds.getData(0, index);
    }

    public int getPortIndex(Port node) {
        if (node == null) {
            return -1;
        }
        return this._getPortIndex(node);
    }

    public SpreadTable getSpreadTable() {
        return this._spreadTable;
    }

    public PortAppearanceProvider getPortAppearanceProvider() {
        return this._portAppearanceProvider;
    }

    public void setPortAppearanceProvider(PortAppearanceProvider provider) {
        if (this._portAppearanceProvider != provider) {
            this._portAppearanceProvider = provider;
            this.repaint();
        }
    }

    public int getSelectedPortCount() {
        OneDSelection sel = this._getGrid().getSelection().getRowSelection();
        return sel.getSelectedItemCount();
    }

    public Port getSelectedPort(int index) {
        OneDSelection sel = this._getGrid().getSelection().getRowSelection();
        int portIndex = sel.getSelectedItemAtIndex(index);
        if (portIndex < 0 || portIndex >= sel.getSelectedItemCount()) {
            return null;
        }
        return this.getPort(portIndex);
    }

    public Port[] getSelectedPorts() {
        OneDSelection sel = this._getGrid().getSelection().getRowSelection();
        int count = sel.getSelectedItemCount();
        Port[] ports = null;
        if (count != 0) {
            ports = new Port[count];
            for (int i = 0; i < count; ++i) {
                ports[i] = this.getPort(sel.getSelectedItemAtIndex(i));
            }
        }
        return ports;
    }

    public boolean isPortSelected(Port port) {
        int index = this.getPortIndex(port);
        return index == -1 ? false : this._getGrid().getSelection().containsRow(index);
    }

    public void setPortSelected(Port port, boolean selected) {
        int index = this.getPortIndex(port);
        if (index != -1) {
            TwoDSelection s = this._getGrid().getSelection();
            s = selected ? (s.isEmpty() ? new TwoDSelection(index, true) : s.addRows(index, 1)) : s.removeRows(index, 1);
            try {
                this._getGrid().setSelection(s);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean isNodeExpanded(Node node) {
        if (node == null) {
            return false;
        }
        if (this.isCreateMode()) {
            if (this._expansionCache == null) {
                return false;
            }
            Object o = this._expansionCache.get(node);
            if (o == null) {
                return true;
            }
            return Boolean.TRUE.equals(o);
        }
        NodeDataSource ds = this._getDataSource();
        return ds.isNodeExpanded(node);
    }

    public void setNodeExpanded(Node node, boolean expanded) {
        if (node != null) {
            if (this.isCreateMode()) {
                if (this._expansionCache == null) {
                    this._expansionCache = new Hashtable();
                }
                this._expansionCache.put(node, new Boolean(expanded));
            } else {
                NodeDataSource ds = this._getDataSource();
                ds.setNodeExpanded(node, expanded);
            }
        }
    }

    public int getSortedColumn() {
        return this._sorter.getLastColumn();
    }

    public boolean isSortAscending() {
        int last = this.getSortedColumn();
        return last == -1 ? false : !this._sorter.getColumnAscending(last);
    }

    public void setSortedColumn(int column, boolean ascending) {
        this._sorter.sort(column, ascending);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void requestFocus() {
        this._getGrid().requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        enabled = this.isEnabled();
        this._scrollBox.setEnabled(enabled);
        this._spreadTable.setEnabled(enabled);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    protected void processEventImpl(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        int id = e.getID();
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumer = this._actionListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (id) {
            case 1001: {
                while (enumer.hasMoreElements()) {
                    ((ActionListener)enumer.nextElement()).actionPerformed(e);
                }
                break;
            }
        }
    }

    protected void updateUI(Class which) {
        if (which == NodeComponent.class) {
            this.updateUI();
        }
    }

    static Comparator __getComparator(int column, boolean ascending, Locale l) {
        Comparator base = null;
        switch (column) {
            case 1: 
            case 2: 
            case 5: {
                base = BooleanComparator.getComparator();
                break;
            }
            case 3: {
                base = new StringComparator(Collator.getInstance(l));
                break;
            }
            case 4: {
                base = new ClassComparator();
            }
        }
        return new PortComparator(base, column, ascending, l);
    }

    void locationChanged() {
        this.__firePropertyChanged(PROPERTY_PORT_LOCATION, Boolean.FALSE, Boolean.TRUE);
    }

    void __firePortSelection(int row, boolean selected) {
        Port p = this.getPort(row);
        if (p != null) {
            Port newValue;
            Port old;
            if (selected) {
                old = null;
                newValue = p;
            } else {
                newValue = null;
                old = p;
            }
            this.__firePropertyChanged(PROPERTY_PORT_SELECTION_COUNT, old, newValue);
        }
    }

    void __fireActionEvent(Object node, String command, int modifiers) {
        this.processEvent(new ActionEvent(node, 1001, command, modifiers));
    }

    void __portRemoved(Port p) {
        int index = this.getPortIndex(p);
        if (index != -1 && this._getGrid().getSelection().containsRow(index)) {
            TwoDSelection s = this._getGrid().getSelection();
            s.removeRows(index, 1);
            try {
                this._getGrid().setSelection(s);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.__firePropertyChanged(PROPERTY_PORT_SELECTION_COUNT, p, null);
        }
    }

    void __fireExpansionChanged(Node node, boolean expanded) {
        Node newValue;
        Node old;
        this.__invalidate();
        if (expanded) {
            old = null;
            newValue = node;
        } else {
            newValue = null;
            old = node;
        }
        this.__firePropertyChanged(PROPERTY_NODE_EXPANDED, old, newValue);
    }

    void __firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    void __invalidate() {
        this.invalidate();
        this._scrollBox.invalidate();
    }

    NodeDataSource _getDataSource() {
        return (NodeDataSource)this._getGrid().getModel();
    }

    void __updateUI() {
        this.freezeRepaints();
        try {
            Grid g = this.getSpreadTable().getGrid();
            if (this._getDataSource().isHGrid()) {
                HGridHandler hGridHandler = new HGridHandler();
                hGridHandler.setExpandedIcon(_sIMAGE_EXPANDED);
                hGridHandler.setCollapsedIcon(_sIMAGE_COLLAPSED);
                hGridHandler.setIndentWidth(9);
                g.setColumnPainter(3, (Painter)hGridHandler);
                g.setColumnCellInputHandler(3, (CellInputHandler)new Handler((CellInputHandler)hGridHandler));
            } else {
                HGridHandler hGridHandler = new HGridHandler();
                hGridHandler.setExpandedIcon(null);
                hGridHandler.setCollapsedIcon(null);
                hGridHandler.setIndentWidth(0);
                g.setColumnPainter(3, (Painter)hGridHandler);
                g.setColumnCellInputHandler(3, (CellInputHandler)new Handler(null));
            }
            this.__invalidate();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _checkScroller(int index) {
        Grid g = this._getGrid();
        int firstRow = g.getFirstRowOnScreen();
        int lastRow = firstRow + g.getOnScreenRowCount() - 1;
        if (index == firstRow) {
            NodeAutoScroller.getAutoScroller().schedule(this, true);
        } else if (index == lastRow) {
            NodeAutoScroller.getAutoScroller().schedule(this, false);
        } else {
            NodeAutoScroller.getAutoScroller().cancel(this);
        }
    }

    private int _getGridOffset() {
        int y = 0;
        for (Container parent = this._getGrid().getParent(); parent != this; parent = parent.getParent()) {
            y += parent.getLocation().y;
        }
        return y;
    }

    private Grid _getGrid() {
        return this.getSpreadTable().getGrid();
    }

    private int _getPortIndex(Port port) {
        if (port == null) {
            return -1;
        }
        return this._getDataSource().getPortIndex(port);
    }

    private int _getNameColumnPrefSize() {
        int width = 0;
        Grid grid = this.getSpreadTable().getGrid();
        Painter painter = grid.getColumnPainter(3);
        AppearanceManager am = grid.getAppearanceManager();
        for (int i = 0; i < grid.getRowCount(); ++i) {
            ImmInsets insets;
            int extra = 0;
            PaintContext context = grid.getCellPaintContext(3, i);
            Dimension prefSize = painter.getPreferredSize(context);
            Appearance a = am.getCellPaintingAppearance(3, i);
            BorderPainter border = a.getBorderPainter();
            if (border != null) {
                insets = border.getInsets(context);
                extra += insets.left + insets.right;
            }
            insets = a.getInsets();
            prefSize.width += (extra += insets.left + insets.right);
            if (prefSize.width <= width) continue;
            width = prefSize.width;
        }
        return width;
    }

    private void _recalculateNameColumn(int gridWidth) {
        if (gridWidth == 0) {
            return;
        }
        int width = this._getNameColumnPrefSize();
        Grid grid = this.getSpreadTable().getGrid();
        if (grid.isColumnVisible(1)) {
            gridWidth -= 18;
        }
        if (grid.isColumnVisible(5)) {
            gridWidth -= 20;
        }
        if (grid.isColumnVisible(2)) {
            gridWidth -= 18;
        }
        if (grid.isColumnVisible(4)) {
            gridWidth -= 18;
        }
        if (width > gridWidth && gridWidth > 0) {
            width = gridWidth;
        } else if (width < gridWidth) {
            width = gridWidth;
        }
        this.getSpreadTable().setColumnWidth(3, width);
    }

    private void _showMenu(Grid grid, int column, int row, int x, int y) {
        if (this.getGraph() != null) {
            Point p = this._translatePoint(grid, column, row, x, y);
            this.getGraph().showMenuForPort(this.getPort(row), this, p.x, p.y);
        }
    }

    private Point _translatePoint(Grid grid, int column, int row, int x, int y) {
        Point p = grid.getCanvasOrigin();
        x += grid.getColumnPosition(column);
        y += grid.getRowPosition(row);
        for (Object parent = grid; parent != this; parent = parent.getParent()) {
            Point temp = parent.getLocation();
            x += temp.x;
            y += temp.y;
        }
        return new Point(x, y);
    }

    private static boolean _isPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return true;
        }
        return (e.getModifiers() & 0x10) == 0;
    }

    protected Image getSourceableImage(Port port) {
        return port instanceof Node ? _sIMAGE_NODE_SOURCEABLE : _sIMAGE_SOURCEABLE;
    }

    protected Image getTargetableImage(Port port) {
        return port instanceof Node ? _sIMAGE_NODE_TARGETABLE : _sIMAGE_TARGETABLE;
    }

    protected Image getSourcedImage(Port port) {
        return _sIMAGE_SOURCED;
    }

    protected Image getTargetedImage(Port port) {
        return _sIMAGE_TARGETED;
    }

    protected Image getKeyImage(Port port) {
        return _sIMAGE_KEY;
    }

    protected Image getDataTypeImage(Port port, Class type) {
        if (type == null) {
            return null;
        }
        if (type == Byte.class || type == Byte.TYPE || type == Double.class || type == Double.TYPE || type == BigDecimal.class || type == BigInteger.class || type == Float.class || type == Float.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Number.class || type == Short.class || type == Short.TYPE) {
            return _sIMAGE_NUMBER;
        }
        if (type == String.class || type == StringBuffer.class || type == Character.class || type == Character.TYPE) {
            return _sIMAGE_STRING;
        }
        if (Date.class.isAssignableFrom(type)) {
            return _sIMAGE_DATE;
        }
        return null;
    }

    static {
        _sIMAGE_NODE_SOURCEABLE = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/group_source.gif");
        _sIMAGE_NODE_TARGETABLE = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/group_target.gif");
        _sIMAGE_STRING = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/data_string.gif");
        _sIMAGE_NUMBER = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/data_number.gif");
        _sIMAGE_DATE = ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/data_date.gif");
        _sIMAGE_EXPANDED = new ImageIcon(ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/group_collapse.gif"));
        _sIMAGE_COLLAPSED = new ImageIcon(ImageUtils.getImageResource(NodeComponent.class, (String)"/oracle/bali/dbUI/graph/images/group_expand.gif"));
    }

    private class Listener
    implements AdjustmentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            NodeComponent.this.locationChanged();
        }

        public void rowScrolled(GridEvent e) {
            NodeComponent.this.locationChanged();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if ("edgeCount".equals(name)) {
                NodeComponent.this.repaint();
            } else if ("selection".equals(name)) {
                int newRow;
                TwoDSelection oldSel = (TwoDSelection)oldValue;
                TwoDSelection newSel = (TwoDSelection)newValue;
                int oldRow = oldSel.getSingleRow();
                if (oldRow != -1) {
                    NodeComponent.this.__firePortSelection(oldRow, false);
                }
                if ((newRow = newSel.getSingleRow()) != -1) {
                    NodeComponent.this.__firePortSelection(newRow, true);
                }
            }
        }
    }

    private class Handler
    extends ProxyInputHandler {
        public Handler(CellInputHandler toWrap) {
            if (toWrap == null) {
                toWrap = NullInputHandler.getCellInputHandler();
            }
            this.setDefaultCellInputHandler(toWrap);
        }

        public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
            if (grid.isEnabled() && NodeComponent._isPopupTrigger(e)) {
                TwoDSelection s = new TwoDSelection(row, true);
                try {
                    grid.setSelection(s);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                grid.requestFocus(column, row, (AWTEvent)e);
                e.consume();
            }
            super.mousePressed(e, grid, column, row);
        }

        public void mouseReleased(MouseEvent e, Grid grid, int column, int row) {
            if (grid.isEnabled() && NodeComponent._isPopupTrigger(e)) {
                NodeComponent.this._showMenu(grid, column, row, e.getX(), e.getY());
                e.consume();
            }
            super.mouseReleased(e, grid, column, row);
        }

        public void keyPressed(KeyEvent e, Grid grid, int column, int row) {
            super.keyPressed(e, grid, column, row);
            if (!e.isConsumed() && grid.isEnabled() && e.getKeyCode() == 121 && e.getModifiers() == 1) {
                NodeComponent.this._showMenu(grid, column, row, grid.getSize().width / 2, grid.getRowHeight(row) * 2 / 3);
                e.consume();
            }
        }
    }

    private class _Table
    extends SpreadTable {
        _Table(TwoDModel ds, OneDModel cds, OneDModel rds) {
            super(ds, cds, rds);
        }

        protected Grid createGrid(TwoDModel dataSource) {
            return new _Grid(dataSource);
        }

        protected Header createColumnHeader(OneDModel ds) {
            return new _Header(ds);
        }

        private class _Header
        extends Header {
            public _Header(OneDModel model) {
                super(model);
            }

            protected int getPaintState() {
                return super.getPaintState() | 4;
            }

            protected Header.AccessibleHeader createAccessibleHeader() {
                return new AHeader();
            }

            private class AHeader
            extends Header.AccessibleHeader {
                public AHeader() {
                    super((Header)_Header.this);
                }

                public String getAccessibleName(int index) {
                    String key = null;
                    String name = null;
                    switch (index) {
                        case 2: {
                            key = NodeComponent._KEY_KEY;
                            break;
                        }
                        case 3: {
                            key = NodeComponent._KEY_COLUMN_NAME;
                            break;
                        }
                        case 1: {
                            key = NodeComponent._KEY_TARGETABLE;
                            break;
                        }
                        case 4: {
                            key = NodeComponent._KEY_DATATYPE;
                            break;
                        }
                        case 5: {
                            key = NodeComponent._KEY_SOURCEABLE;
                            break;
                        }
                        default: {
                            name = super.getAccessibleName(index);
                        }
                    }
                    if (key != null) {
                        ResourceBundle b = ResourceBundle.getBundle(NodeComponent._GRAPH_BUNDLE, this.getLocale());
                        name = b.getString(key);
                    }
                    return name;
                }

                public String getAccessibleDescription(int index) {
                    String desc = null;
                    String key = null;
                    switch (index) {
                        case 2: {
                            key = NodeComponent._KEY_KEY_DESC;
                            break;
                        }
                        case 3: {
                            key = NodeComponent._KEY_COLUMN_NAME_DESC;
                            break;
                        }
                        case 1: {
                            key = NodeComponent._KEY_TARGETABLE_DESC;
                            break;
                        }
                        case 4: {
                            key = NodeComponent._KEY_DATATYPE_DESC;
                            break;
                        }
                        case 5: {
                            key = NodeComponent._KEY_SOURCEABLE_DESC;
                            break;
                        }
                        default: {
                            desc = super.getAccessibleDescription(index);
                        }
                    }
                    if (key != null) {
                        ResourceBundle b = ResourceBundle.getBundle(NodeComponent._GRAPH_BUNDLE, this.getLocale());
                        desc = b.getString(key);
                    }
                    return desc;
                }
            }
        }

        private class _Grid
        extends Grid {
            public _Grid(TwoDModel ds) {
                super(ds);
            }

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            protected Grid.AccessibleGrid createAccessibleGrid() {
                return new AGrid();
            }

            protected void processFocusEvent(FocusEvent e) {
                if (e.getID() == 1004 && this.getFocusCell() != null && this.getFocusCell().column != -1 && this.getFocusCell().column != 3 && this.getFocusCell().row >= this.getRowCount()) {
                    super.requestFocus(3, 0, null);
                }
                super.processFocusEvent(e);
            }

            public boolean requestFocus(int column, int row, AWTEvent e) {
                return super.requestFocus(3, row, e);
            }

            protected void paintFocusCell(PaintContext context, Graphics g) {
                Cell focus = this.getFocusCell();
                if (this.getDrawFocusCellHighlite() && focus != null && this.isColumnOnScreen(focus.column) && this.isRowOnScreen(focus.row) && this.hasFocus()) {
                    int x = this.getColumnPosition(focus.column) + 1;
                    int y = this.getRowPosition(focus.row) + 1;
                    int width = this.getColumnWidth(focus.column) - 2;
                    int height = this.getRowHeight(focus.row) - 2;
                    context = this.getCellPaintContext(focus.column, focus.row);
                    Painter painter = GridFocusPainter.getPainter();
                    painter.paint(context, g, x, y, width, height);
                }
            }

            public void reshape(int x, int y, int width, int height) {
                int oldHeight = this.getHeight();
                super.reshape(x, y, width, height);
                if (!NodeComponent.this.isCreateMode()) {
                    if (oldHeight == 0 || height != oldHeight) {
                        NodeComponent.this.locationChanged();
                    }
                    NodeComponent.this._recalculateNameColumn(this.getInnerWidth());
                }
            }

            protected void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
                if (this.isEnabled() && e.getID() == 500 && !NodeComponent._isPopupTrigger(e)) {
                    Point p = this.convertOuterToCanvas(e.getX(), e.getY());
                    int row = this.getRowAt(p.y);
                    Port port = NodeComponent.this.getPort(row);
                    if (port != null) {
                        if (e.getClickCount() == 1) {
                            NodeComponent.this.__fireActionEvent(port, NodeComponent.COMMAND_PORT_SINGLE_CLICK, e.getModifiers());
                        } else if (e.getClickCount() % 2 == 0) {
                            NodeComponent.this.__fireActionEvent(port, NodeComponent.COMMAND_PORT_DOUBLE_CLICK, e.getModifiers());
                        }
                    }
                }
            }

            public Dimension getPreferredSize() {
                int width = 0;
                int height = this.getRowCount() * this.getDefaultRowHeight();
                if (this.getHorizontalSeparatorsVisible()) {
                    Painter p = this.getHorizontalSeparatorPainter();
                    int size = p.getMinimumSize((PaintContext)this.getPaintContext()).height;
                    height += (this.getRowCount() - 1) * size;
                }
                if (this.isColumnVisible(1)) {
                    width += 18;
                }
                if (this.isColumnVisible(5)) {
                    width += 20;
                }
                if (this.isColumnVisible(2)) {
                    width += 18;
                }
                if (this.isColumnVisible(4)) {
                    width += 18;
                }
                return new Dimension(width += NodeComponent.this._getNameColumnPrefSize(), height);
            }

            private class AGrid
            extends Grid.AccessibleGrid {
                public AGrid() {
                    super((Grid)_Grid.this);
                }

                protected String getAccessibleName(int column, int row, Object data) {
                    Class type;
                    String typeName;
                    int index;
                    ResourceBundle b = ResourceBundle.getBundle(NodeComponent._GRAPH_BUNDLE, this.getLocale());
                    Port c = NodeComponent.this.getPort(row);
                    boolean selected = false;
                    TwoDModel ds = _Table.this.getGrid().getModel();
                    boolean isKey = ds.getData(2, row) != null;
                    Object columnName = ds.getData(3, row);
                    if (columnName instanceof HDataObject) {
                        columnName = ((HDataObject)columnName).getData();
                    }
                    if ((index = (typeName = (type = c.getDataType()) == null ? " null " : type.toString()).lastIndexOf(".")) != -1) {
                        typeName = typeName.substring(index + 1);
                    }
                    String name = columnName + "";
                    String key = this._getKey(selected, isKey);
                    String text = b.getString(key);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{columnName, typeName};
                    name = form.format(args);
                    return name;
                }

                private String _getKey(boolean selected, boolean isKey) {
                    String key = null;
                    key = selected ? (isKey ? NodeComponent._KEY_S_P : NodeComponent._KEY_S) : (isKey ? NodeComponent._KEY_P : NodeComponent._KEY_NONE);
                    return key;
                }
            }
        }
    }

    private class AM
    extends AbstractAppearanceManager {
        private Appearance _imageDropAppearance;
        private Appearance _dropAppearance;
        private Appearance _appearance = (Appearance)UIManager.get("Grid.DefaultAppearance");
        private Appearance _imageAppearance;

        public Appearance getCellPaintingAppearance(int column, int row) {
            Port p = NodeComponent.this.getPort(row);
            if (p == NodeComponent.this.getDropTargetPort()) {
                return this._getDropAppearance(column);
            }
            if (NodeComponent.this.getPortAppearanceProvider() == null) {
                return this._getAppearance(column);
            }
            Appearance a = NodeComponent.this.getPortAppearanceProvider().getPortAppearance(p, this._appearance);
            return a == null || a == this._appearance ? this._getAppearance(column) : a;
        }

        private Appearance _getAppearance(int column) {
            Appearance a = this._appearance;
            if (column != 3) {
                if (this._imageAppearance == null) {
                    this._imageAppearance = this._appearance.copy();
                    this._imageAppearance.setInsets(ImmInsets.getEmptyInsets());
                }
                a = this._imageAppearance;
            }
            return a;
        }

        private void _createDropAppearance() {
            this._dropAppearance = this._appearance.copy();
            Color bg = NodeComponent.this.getSpreadTable().getGrid().getUIDefaults().getColor("controlDkShadow");
            this._dropAppearance.setBackground(bg);
            this._dropAppearance.setSelectBackground(bg);
            this._dropAppearance.setForeground(Color.white);
            this._dropAppearance.setSelectForeground(Color.white);
        }

        private Appearance _getDropAppearance(int column) {
            if (this._dropAppearance == null) {
                this._createDropAppearance();
            }
            Appearance a = this._dropAppearance;
            if (column != 3) {
                if (this._imageDropAppearance == null) {
                    this._imageDropAppearance = this._dropAppearance.copy();
                    this._imageDropAppearance.setInsets(ImmInsets.getEmptyInsets());
                }
                a = this._imageDropAppearance;
            }
            return a;
        }
    }

    private class HGridHandler
    extends HCellHandler {
        private HGridHandler() {
        }

        protected boolean isBackgroundUsed() {
            return false;
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super((JComponent)((Object)NodeComponent.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

