/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComboBox;
import oracle.bali.dbUI.constraintComponent.MultiDescriptorComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.share.datatransfer.TransferUtils;

class MDCJDKDropSupport
implements DropTargetListener {
    private MultiDescriptorComponent _component;
    private JComboBox _item;

    public MDCJDKDropSupport(MultiDescriptorComponent comp, JComboBox item) {
        this._component = comp;
        this._item = item;
        DropTarget dummy = new DropTarget(this._item, this);
        dummy = new DropTarget(this._item.getEditor().getEditorComponent(), this);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this._acceptDrag(dtde)) {
            this._component.dragEnter(dtde.getDropTargetContext().getComponent());
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this._acceptDrag(dtde)) {
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
        this._component.dragExit(dtde.getDropTargetContext().getComponent());
    }

    public void drop(DropTargetDropEvent dtde) {
        Component comp = dtde.getDropTargetContext().getComponent();
        this._component.dragExit(comp);
        DropTargetContext context = dtde.getDropTargetContext();
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        try {
            Object data = transfer.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            if (data instanceof DataDescriptor) {
                context.dropComplete(true);
                this._component.drop(comp, (DataDescriptor)data);
            } else {
                context.dropComplete(false);
            }
        }
        catch (Exception e) {
            context.dropComplete(false);
        }
    }

    boolean _acceptDrag(DropTargetDragEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return true;
        }
        return TransferUtils.supportsDataFlavor((DataFlavor[])flavors, (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
    }
}

