/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.util.ArrayCollection;
import oracle.bali.dbUI.util.Collection;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.util.LocaleUtils;

public class CollectionConstraintComp
extends LWComponent
implements ConstraintComponent,
Accessible {
    private static final String _EQUAL_KEY = "EQUAL";
    private static final String _NOT_EQUAL_KEY = "NOT_EQUAL";
    private Object[] _fullArray = new Object[1];
    private int _objectCount;
    private JComboBox _choice;
    private JList _list;
    private JScrollPane _scrollPane;
    private DataDescriptor _descriptor;

    public CollectionConstraintComp() {
        this(null);
    }

    public CollectionConstraintComp(Collection collection) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.insets = new Insets(2, 1, 2, 1);
        gbc.anchor = 17;
        gbc.gridwidth = -1;
        this._choice = new JComboBox();
        this._choice.setEditable(false);
        gbl.setConstraints(this._choice, gbc);
        this.add(this._choice);
        gbc.insets = new Insets(2, 1, 2, 2);
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 2.0;
        gbc.weighty = 2.0;
        this._list = new JList();
        this._list.setVisibleRowCount(4);
        this._list.getSelectionModel().setSelectionMode(2);
        this._scrollPane = new JScrollPane(this._list);
        gbl.setConstraints(this._scrollPane, gbc);
        this.add(this._scrollPane);
        this._setCollection(collection);
        this._setLocaleText(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setCollection(Collection collection) {
        this._setCollection(collection);
    }

    public Collection getCollection() {
        return this._getCollection();
    }

    public void setInCollection(boolean inCollection) {
        int index = inCollection ? 0 : 1;
        this._choice.setSelectedIndex(index);
    }

    public boolean isInCollection() {
        return this._choice.getSelectedIndex() == 0;
    }

    public void setTestCollection(Collection testCollection) {
        this._list.getSelectionModel().clearSelection();
        if (testCollection != null) {
            Enumeration testEnum = testCollection.getEnumeration();
            while (testEnum.hasMoreElements()) {
                int index = this._getIndex(testEnum.nextElement());
                if (index == -1) continue;
                this._list.setSelectedIndex(index);
            }
        }
    }

    public Collection getTestCollection() {
        int[] indicies = this._list.getSelectedIndices();
        if (indicies == null) {
            return null;
        }
        Object[] array = new Object[indicies.length];
        for (int i = 0; i < indicies.length; ++i) {
            array[i] = this._getObject(indicies[i]);
        }
        return new ArrayCollection(array);
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this._list.getSelectionModel().setSelectionMode(2);
    }

    public boolean isMultipleSelection() {
        return this._list.getSelectionModel().getSelectionMode() == 2;
    }

    public Component getComponent() {
        return this;
    }

    public DataConstraint getDataConstraint() {
        if (this._descriptor == null) {
            return null;
        }
        DCConstant collection = new DCConstant(this.getTestCollection());
        DCVariable name = new DCVariable(this._descriptor);
        int operand = this.isInCollection() ? 5 : 6;
        return new DCCollectionExpression(name, collection, operand);
    }

    public DataDescriptor getDataDescriptor() {
        return this._descriptor;
    }

    public void initState(DataDescriptor descriptor, DataConstraint dataConstraint) {
        this._descriptor = descriptor;
        if (dataConstraint == null) {
            this.setTestCollection(null);
            this.setInCollection(true);
            return;
        }
        boolean not = false;
        if (dataConstraint instanceof DCUnaryExpression) {
            dataConstraint = ((DCUnaryExpression)dataConstraint).getConstraint(0);
            not = true;
        }
        if (!(dataConstraint instanceof DCCollectionExpression)) {
            throw new IllegalArgumentException("dataConstraint " + dataConstraint + " is invalid!");
        }
        DCCollectionExpression e = (DCCollectionExpression)dataConstraint;
        boolean cond = e.getOperand() == 5;
        this.setTestCollection(this._getCollection(e));
        if (not) {
            cond = !cond;
        }
        this.setInCollection(cond);
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        this._setLocaleText(this.getLocale());
    }

    public void requestFocus() {
        this._choice.requestFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    private void _setLocaleText(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        this._updateChoice(b);
    }

    private void _updateChoice(ResourceBundle b) {
        int index = this._choice.getSelectedIndex();
        this._choice.removeAllItems();
        this._choice.addItem(b.getString(_EQUAL_KEY));
        this._choice.addItem(b.getString(_NOT_EQUAL_KEY));
        if (index != -1) {
            this._choice.setSelectedIndex(index);
        }
    }

    private void _setCollection(Collection collection) {
        this._objectCount = 0;
        if (collection != null) {
            Enumeration enumer = collection.getEnumeration();
            while (enumer.hasMoreElements()) {
                if (this._objectCount == this._fullArray.length) {
                    Object[] temp = new Object[this._fullArray.length * 2];
                    System.arraycopy(this._fullArray, 0, temp, 0, this._objectCount);
                    this._fullArray = temp;
                }
                this._fullArray[this._objectCount] = enumer.nextElement();
                ++this._objectCount;
            }
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (int i = 0; i < this._objectCount; ++i) {
            model.addElement(this._fullArray[i].toString());
        }
        this._list.setModel(model);
    }

    private Collection _getCollection() {
        Object[] array = new Object[this._objectCount];
        System.arraycopy(this._fullArray, 0, array, 0, this._objectCount);
        return new ArrayCollection(array);
    }

    private int _getIndex(Object object) {
        for (int i = 0; i < this._objectCount; ++i) {
            if (!this._fullArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    private Object _getObject(int index) {
        return index >= this._objectCount ? null : this._fullArray[index];
    }

    private Collection _getCollection(DCBinaryExpression c) {
        DataConstraint c1 = c.getConstraint(0);
        DataConstraint c2 = c.getConstraint(1);
        Collection e = null;
        if (c1 instanceof DCConstant) {
            e = (Collection)((DCConstant)c1).getValue();
        } else if (c2 instanceof DCConstant) {
            e = (Collection)((DCConstant)c2).getValue();
        }
        return e;
    }
}

