/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.controller.Command;

class UndoCommandWrapper
extends Command {
    private static final int CMD_ID = Ide.findOrCreateCmdID((String)"SqlEditorUndoWrapperCommand");
    private UndoableEdit m_edit;

    UndoCommandWrapper(UndoableEdit undoableEdit) {
        super(CMD_ID, 0);
        this.m_edit = undoableEdit;
    }

    public String getName() {
        return this.m_edit.getPresentationName();
    }

    public int doit() {
        int n = 0;
        if (this.m_edit.canRedo()) {
            try {
                this.m_edit.redo();
                n = 0;
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
        return n;
    }

    public int undo() {
        int n = 1;
        if (this.m_edit.canUndo()) {
            try {
                this.m_edit.undo();
                n = 0;
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
        return n;
    }
}

