/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Component;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.BindDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.ExplainPlanAction;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

class AutotraceAction
extends AnalyzeAction {
    private static final String UNSUFFICIENT_PRIVILEGES = Messages.getString("AutotraceAction.0");
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());
    private String GRANT_CATALOG_ROLE = null;
    private String mystat = null;
    private String sqlId;
    final Map<Integer, Long> snapshotBefore = new HashMap<Integer, Long>();
    private PreparedStatement mainStmt = null;
    private boolean cancelled = false;

    public AutotraceAction(String string, WorksheetContext worksheetContext) {
        super(Messages.getString("WorksheetTaskUI.8"), string, worksheetContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Void doWork() throws TaskException {
        try {
            Map map;
            Serializable serializable;
            Statement statement;
            if (!this.init()) return null;
            String string = Messages.getString("AutotraceAction.1");
            this.showResultPanel();
            try {
                string = this.conn.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.GRANT_CATALOG_ROLE = Messages.getString("AutotraceAction.2") + Messages.getString("AutotraceAction.3") + Messages.getString("AutotraceAction.4") + "grant SELECT_CATALOG_ROLE to " + string + "\n" + "grant SELECT ANY DICTIONARY to" + string + "\n" + Messages.getString("AutotraceAction.9");
            this.mystat = "  select name,value, ROW_NUMBER() OVER (ORDER BY pt.STATISTIC#) num \n  from V$STATNAME sn, V$mystat pt \n  where sn.STATISTIC# = pt.STATISTIC#\n  order by lower(name)\n";
            try {
                statement = this.conn.createStatement();
                statement.execute("alter session set statistics_level=ALL");
                statement.execute("alter session set TIMED_STATISTICS = TRUE");
                statement.close();
            }
            catch (SQLException sQLException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("AutotraceAction.6"), (String)UNSUFFICIENT_PRIVILEGES, null);
                Void void_ = null;
                this.resetCursor();
                return void_;
            }
            if (AutotracePanel.showMyStat()) {
                try {
                    statement = this.conn.prepareStatement(this.mystat);
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        int n = resultSet.getInt("num") - 1;
                        long l = resultSet.getLong("value");
                        this.snapshotBefore.put(n, l);
                    }
                    resultSet.close();
                    statement.close();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 942) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.GRANT_CATALOG_ROLE, (String)UNSUFFICIENT_PRIVILEGES, null);
                        Void void_ = null;
                        this.resetCursor();
                        return void_;
                    }
                    this.logger.fine("sql=" + this.mystat);
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    throw new RuntimeException(Messages.getString("AutotraceAction.25"));
                }
            }
            long l = System.currentTimeMillis();
            String string2 = this.extractSql(null);
            if (string2 == null || "".equals(string2.trim())) {
                Void void_ = null;
                return void_;
            }
            ResultSet resultSet = null;
            try {
                this.sqlId = ExplainPlanAction.stmt2sqlid(string2);
                serializable = Connections.getInstance().getLock(this.conn);
                if (!serializable.tryLock(500L, TimeUnit.MILLISECONDS)) {
                    Void void_ = null;
                    return void_;
                }
                map = BindDialog.getBindValues((String)string2);
                if (map == null) {
                    Void void_ = null;
                    return void_;
                }
                this.mainStmt = DBUtil.getInstance((Connection)this.conn).prepareExecute(string2, map);
                resultSet = this.mainStmt.executeQuery();
                if (this.cancelled) {
                    Void void_ = null;
                    return void_;
                }
                if (resultSet != null && oracle.dbtools.raptor.SerializedData.getInstance().fetchAll) {
                    while (!this.cancelled && resultSet.next()) {
                    }
                }
                if (this.cancelled) {
                    this.mainStmt.cancel();
                    this.mainStmt = null;
                    Void void_ = null;
                    return void_;
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)Messages.getString("Error"), null);
                map = null;
                return map;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (this.mainStmt != null) {
                    try {
                        this.mainStmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (this.conn != null) {
                    Connections.getInstance().unlock(this.conn);
                }
            }
            this.autoTracePanel.tbl.revalidate();
            this.autoTracePanel.getATMdl().originalSQL = string2;
            this.autoTracePanel.mystatsData.reset();
            this.autoTracePanel.mystats.revalidate();
            serializable = ExceptionHandler.wasException();
            if (serializable != null) {
                ExceptionHandler.reset();
                if (!(serializable instanceof SQLException)) {
                    map = null;
                    return map;
                }
                if (((SQLException)serializable).getErrorCode() != 1013) {
                    map = null;
                    return map;
                }
            } else {
                ExceptionHandler.reset();
            }
            this.statementPostProcessing();
            return null;
        }
        finally {
            this.resetCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statementPostProcessing() {
        Object object;
        Object object2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (AutotracePanel.showMyStat()) {
            try {
                preparedStatement = this.conn.prepareStatement(this.mystat);
                resultSet = preparedStatement.executeQuery();
                int n = 0;
                while (resultSet.next()) {
                    int n2 = resultSet.getInt("num") - 1;
                    object2 = resultSet.getString("name");
                    long l = resultSet.getLong("value") - this.snapshotBefore.get(n2);
                    this.autoTracePanel.mystatsData.names.put(n, (String)object2);
                    this.autoTracePanel.mystatsData.values.put(n, l);
                    ++n;
                }
                resultSet.close();
                preparedStatement.close();
                this.autoTracePanel.mystatsData.calculateNonZeroValuedRow2ActualRow();
                object = new Runnable(){

                    @Override
                    public void run() {
                        AutotraceAction.this.autoTracePanel.mystatsData.fireTableDataChanged();
                        AutotraceAction.this.autoTracePanel.mystats.invalidate();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    object.run();
                }
                SwingUtilities.invokeLater((Runnable)object);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                throw new RuntimeException(Messages.getString("AutotraceAction.32"));
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            this.autoTracePanel.mystatsData.names.put(0, Messages.getString("AutotraceAction.33"));
            this.autoTracePanel.mystatsData.values.put(0, -1L);
        }
        String string = null;
        object = null;
        try {
            preparedStatement = this.conn.prepareStatement("select hash_value, child_number from v$sql \n where sql_id = ?  \n order by last_load_time desc");
            preparedStatement.setString(1, this.sqlId);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            string = resultSet.getString("hash_value");
            object = resultSet.getString("child_number");
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 942) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.GRANT_CATALOG_ROLE, (String)UNSUFFICIENT_PRIVILEGES, null);
                return;
            }
            this.logger.log(Level.WARNING, "select hash_value from v$sql", sQLException);
            return;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        this.logger.info("hash_value=" + string);
        this.autoTracePanel.mdlReload(string, (String)object, this.conn);
        this.autoTracePanel.tbl.revalidate();
        object2 = null;
        try {
            object2 = this.conn.createStatement();
            object2.execute("rollback");
            object2.execute("alter session set statistics_level=TYPICAL");
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(Messages.getString("AutotraceAction.45"));
        }
        finally {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
        }
        SerializedData.initColumnWidths(this.autoTracePanel.tbl);
    }

    public boolean cancel() {
        return super.cancel();
    }
}

