/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.OracleDatatypeIdentifiers;
import oracle.jdbc.OraclePreparedStatement;

public class GeneratePreparedStatement
implements OracleDatatypeIdentifiers {
    private String[] m_fieldTypes = null;
    private String m_tableName = null;
    private PreparedStatement m_pStmt = null;
    private static StringBuffer s_insertStmt = new StringBuffer();
    private static int BATCH_SIZE = 250;

    public GeneratePreparedStatement(Connection connection, int n, String[] stringArray, String string) throws SQLException {
        this.m_fieldTypes = stringArray;
        this.m_tableName = string;
        try {
            String string2 = this.buildPreparedStatement();
            this.m_pStmt = connection.prepareStatement(string2);
            ((OraclePreparedStatement)this.m_pStmt).setExecuteBatch(BATCH_SIZE);
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
    }

    private String buildPreparedStatement() {
        s_insertStmt.setLength(0);
        s_insertStmt.append(" INSERT INTO ").append(this.m_tableName).append(" VALUES (");
        for (int i = 0; i < this.m_fieldTypes.length; ++i) {
            if (this.m_fieldTypes[i].equalsIgnoreCase("6")) {
                s_insertStmt.append(" HEXTORAW(?),");
                continue;
            }
            if (this.m_fieldTypes[i].equalsIgnoreCase("7")) {
                s_insertStmt.append(" HEXTORAW(?),");
                continue;
            }
            if (this.m_fieldTypes[i].equalsIgnoreCase("10")) {
                s_insertStmt.append(" ?,");
                continue;
            }
            if (this.m_fieldTypes[i].equalsIgnoreCase("5")) {
                s_insertStmt.append(" TO_DATE(SUBSTR(?,1,10),'YYYY/MM/DD'),");
                continue;
            }
            s_insertStmt.append(" ?,");
        }
        s_insertStmt.deleteCharAt(s_insertStmt.length() - 1);
        s_insertStmt.append(" ) ");
        return s_insertStmt.toString();
    }

    public void setPreparedStatementValues(List list) throws SQLException {
        for (int i = 0; i < this.m_fieldTypes.length; ++i) {
            String string = this.m_fieldTypes[i];
            try {
                String string2;
                if (string.equalsIgnoreCase("1")) {
                    string2 = (String)list.get(i);
                    if (string2.length() == 0) {
                        this.m_pStmt.setString(i + 1, " ");
                        continue;
                    }
                    this.m_pStmt.setString(i + 1, string2);
                    continue;
                }
                if (string.equalsIgnoreCase("2")) {
                    this.m_pStmt.setString(i + 1, (String)list.get(i));
                    continue;
                }
                if (string.equalsIgnoreCase("3")) {
                    string2 = (String)list.get(i);
                    if ((string2 = string2.trim()).length() == 0) {
                        this.m_pStmt.setInt(i + 1, 0);
                        continue;
                    }
                    int n = Integer.parseInt(string2);
                    this.m_pStmt.setInt(i + 1, n);
                    continue;
                }
                if (string.equalsIgnoreCase("4")) {
                    this.m_pStmt.setString(i + 1, (String)list.get(i));
                    continue;
                }
                if (string.equalsIgnoreCase("5")) {
                    string2 = (String)list.get(i);
                    this.m_pStmt.setString(i + 1, string2);
                    continue;
                }
                if (string.equalsIgnoreCase("6")) {
                    this.m_pStmt.setString(i + 1, (String)list.get(i));
                    continue;
                }
                if (string.equalsIgnoreCase("7")) {
                    this.m_pStmt.setString(i + 1, (String)list.get(i));
                    continue;
                }
                if (string.equalsIgnoreCase("8")) {
                    string2 = (String)list.get(i);
                    if (string2.length() == 0) {
                        this.m_pStmt.setString(i + 1, " ");
                        continue;
                    }
                    this.m_pStmt.setString(i + 1, string2);
                    continue;
                }
                if (string.equalsIgnoreCase("9")) {
                    this.m_pStmt.setString(i + 1, (String)list.get(i));
                    continue;
                }
                if (string.equalsIgnoreCase("10")) {
                    string2 = (String)list.get(i);
                    ClobHelper clobHelper = new ClobHelper(string2);
                    this.m_pStmt.setCharacterStream(i + 1, clobHelper.getReader(), (int)clobHelper.getLength());
                    continue;
                }
                if (!string.equalsIgnoreCase("11")) continue;
                string2 = (String)list.get(i);
                this.m_pStmt.setBytes(i + 1, string2.getBytes());
                continue;
            }
            catch (SQLException sQLException) {
                throw new SQLException(sQLException.getMessage());
            }
        }
    }

    public PreparedStatement getPreparedStatement() {
        return this.m_pStmt;
    }

    public String getInsertValues(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i)).append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public int executeUpdate() throws SQLException {
        return this.m_pStmt.executeUpdate();
    }

    public void cleanUp() {
        try {
            this.m_pStmt.close();
            this.m_pStmt = null;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString() + "\n" + this.m_tableName, sQLException);
        }
    }
}

