/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.gallery.AllItemsFolder;
import oracle.ide.gallery.CategoryTreeCellRenderer;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryElementHierarchyMgr;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryItemsList;
import oracle.ide.gallery.GalleryItemsListCellRenderer;
import oracle.ide.gallery.GalleryItemsListModel;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Invokable;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

final class ObjectGalleryPanel
extends JPanel {
    private static final boolean DEBUG_GALLERY_ITEMS = GalleryHandler.DEBUG_GALLERY_HOOK_ITEMS;
    private static final double MAIN_SPLITTER_RESIZE_WEIGHT = 0.33;
    private static final Border UNDERLINE_BORDER = JavatoolsBorderFactory.createBottomBorder((Color)SystemColor.controlShadow);
    final SearchField searchField = new SearchField();
    final JPanel searchPanel = new JPanel();
    final JSplitPane splitPane = new JSplitPane(1, true);
    final JLabel lblCat = new JLabel();
    final JLabel lblItems = new JLabel();
    final JCheckBox chkShowAllDescriptions = new JCheckBox();
    final JLabel lblDescription = new JLabel();
    final JScrollPane jspTreeCat = new JScrollPane();
    final JScrollPane jspListItems = new JScrollPane(20, 31);
    final JPanel itemsListHeaderPanel = new JPanel();
    final JPanel itemsContainerPanel = new JPanel();
    final JList itemsList = new GalleryItemsList();
    final JTree treeCat = new JTree();
    final GridBagLayout gridBagLayout1 = new GridBagLayout();
    final BorderLayout borderLayout = new BorderLayout(5, 10);
    final NoResultsFoundPanel noSearchResultsPanel;
    private transient RootGalleryFolder _model;
    private transient Context _context;
    private transient TreeModel _treeModel;
    private transient AllItemsFolder _allItemsFolder;
    private boolean _explicitInitialSel;
    private boolean _persistLastSelectionIndex = true;
    private final GalleryElementHierarchyMgr _hierarchyMgr = new GalleryElementHierarchyMgr();

    ObjectGalleryPanel(RootGalleryFolder model, Context context) {
        this._model = model;
        this._context = context;
        this.setName("NormalGalleryPanel");
        this.noSearchResultsPanel = new NoResultsFoundPanel();
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.setPreferredSize(new Dimension(450, 300));
        ResourceUtils.resButton((AbstractButton)this.chkShowAllDescriptions, (String)GalleryArb.getString((int)9));
        this.chkShowAllDescriptions.setName("ShowAllDescriptionsCheckbox");
        ResourceUtils.resLabel((JLabel)this.lblCat, (Component)this.treeCat, (String)GalleryArb.getString((int)7));
        ResourceUtils.resLabel((JLabel)this.lblItems, (Component)this.itemsList, (String)GalleryArb.getString((int)10));
        this.searchField.setName("SearchField");
        this.searchField.getTextField().setName("SeachTextField");
        this.searchField.setStyle(SearchField.Style.FILTER);
        this.searchField.setKeyEventTargetComponent((Component)this.treeCat);
        this.searchPanel.setLayout(new GridBagLayout());
        this.noSearchResultsPanel.setName("NoResultsFound");
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridy = 0;
        g.gridx = 1;
        g.weightx = 0.5;
        g.fill = 2;
        g.weightx = 1.0;
        this.searchPanel.add((Component)this.searchField, g);
        ++g.gridx;
        this.searchPanel.add((Component)Box.createHorizontalBox(), g);
        ++g.gridx;
        this.treeCat.setName(this.getName() + ".CategoryList");
        this.treeCat.setExpandsSelectedPaths(true);
        this.treeCat.setRootVisible(false);
        this.treeCat.setShowsRootHandles(true);
        this.treeCat.setScrollsOnExpand(true);
        this.treeCat.getSelectionModel().setSelectionMode(1);
        this.jspTreeCat.setBorder(null);
        this.jspTreeCat.setColumnHeaderView(this.lblCat);
        this.jspTreeCat.setViewportView(this.treeCat);
        this.itemsList.setName(this.getName() + ".ItemsList");
        this.itemsList.setBorder(null);
        this.itemsList.setAutoscrolls(true);
        this.itemsList.setOpaque(true);
        this.itemsList.setBackground(Color.WHITE);
        this.itemsList.setSelectionMode(0);
        this.lblCat.setBorder(BorderFactory.createCompoundBorder(UNDERLINE_BORDER, BorderFactory.createEmptyBorder(3, 2, 3, 2)));
        this.jspListItems.setName(this.getName() + ".JSPItemsList");
        this.jspListItems.setBorder(BorderFactory.createEmptyBorder());
        this.jspListItems.getViewport().setBackground(Color.WHITE);
        this.splitPane.setName("ItemsListSplitPane");
        this.splitPane.setResizeWeight(0.33);
        this.itemsListHeaderPanel.setLayout(new GridBagLayout());
        this.itemsListHeaderPanel.setBorder(BorderFactory.createCompoundBorder(UNDERLINE_BORDER, BorderFactory.createEmptyBorder(1, 2, 1, 2)));
        this.itemsListHeaderPanel.add((Component)this.lblItems, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.itemsListHeaderPanel.add((Component)this.chkShowAllDescriptions, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.itemsContainerPanel.setLayout(new BorderLayout());
        this.itemsContainerPanel.setBorder(null);
        this.itemsContainerPanel.setOpaque(true);
        this.itemsContainerPanel.setBackground(SystemColor.WHITE);
        this.itemsContainerPanel.add((Component)this.itemsListHeaderPanel, "North");
        this.jspListItems.setViewportView(this.itemsList);
        this.itemsContainerPanel.add((Component)this.jspListItems, "Center");
        this.splitPane.setLeftComponent(this.jspTreeCat);
        this.splitPane.setRightComponent(this.itemsContainerPanel);
        this.add((Component)this.searchPanel, "North");
        this.add((Component)this.splitPane, "Center");
    }

    private void postInit() {
        this.treeCat.setCellRenderer(new CategoryTreeCellRenderer());
        this.itemsList.setCellRenderer(new GalleryItemsListCellRenderer(this._context, this._hierarchyMgr, this._model.isShowDescriptions()));
        this.chkShowAllDescriptions.setSelected(this._model.isShowDescriptions());
        EventHandler listener = new EventHandler();
        this.addHierarchyListener(listener);
        this.itemsList.getSelectionModel().addListSelectionListener(listener);
        this.itemsList.addMouseListener(listener);
        this.treeCat.addTreeSelectionListener(listener);
        this.treeCat.addTreeExpansionListener(listener);
        this.searchField.addSearchListener((SearchListener)listener);
        this.chkShowAllDescriptions.addItemListener(listener);
        this.rebuildGallery();
        ToolTipManager.sharedInstance().registerComponent(this.treeCat);
    }

    private TreeModel createTreeModel() {
        ArrayList<GalleryElement> allElements = new ArrayList<GalleryElement>();
        GalleryTreeNode root = new GalleryTreeNode(this._model, allElements);
        this.pruneEmtpyFolders(root);
        this._allItemsFolder = new AllItemsFolder(this._hierarchyMgr, allElements);
        root.add(new GalleryTreeNode(this._allItemsFolder, null));
        this._treeModel = new DefaultTreeModel(root);
        return this._treeModel;
    }

    private void pruneEmtpyFolders(GalleryTreeNode folderNode) {
        ArrayList<GalleryTreeNode> toPrune = new ArrayList<GalleryTreeNode>();
        Enumeration<TreeNode> e = folderNode.children();
        while (e.hasMoreElements()) {
            GalleryTreeNode child = (GalleryTreeNode)e.nextElement();
            if (child.getChildCount() > 0) {
                this.pruneEmtpyFolders(child);
                continue;
            }
            if (child.getGalleryFolder().getElementChildren().length != 0 || this._model.isFolderPopulatedLazily(child.getGalleryFolder().getName())) continue;
            toPrune.add(child);
        }
        for (GalleryTreeNode node : toPrune) {
            folderNode.remove(node);
        }
    }

    private GalleryFolder getGalleryFolder(TreePath path) {
        if (path == null) {
            return null;
        }
        Object lastPath = path.getLastPathComponent();
        if (!(lastPath instanceof GalleryTreeNode)) {
            return null;
        }
        GalleryTreeNode treeNode = (GalleryTreeNode)lastPath;
        return treeNode.getGalleryFolder();
    }

    private void restoreTreeExpansion() {
        GalleryTreeNode root = this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            GalleryTreeNode node = (GalleryTreeNode)e.nextElement();
            GalleryFolder folder = node.getGalleryFolder();
            if (!folder.isExpanded()) continue;
            this.treeCat.expandPath(new TreePath(node.getPath()));
        }
    }

    private boolean restoreTreeSelection(TreePath selectedPath) {
        GalleryFolder selectedFolder = this.getGalleryFolder(selectedPath);
        if (selectedFolder instanceof AllItemsFolder) {
            TreePath path = new TreePath(new Object[]{this.getRoot(), this.getRoot().getLastChild()});
            this.treeCat.setSelectionPath(path);
            this.treeCat.scrollPathToVisible(path);
            return true;
        }
        GalleryTreeNode root = this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            GalleryTreeNode next = (GalleryTreeNode)e.nextElement();
            if (selectedFolder != next.getUserObject()) continue;
            TreePath path = new TreePath(next.getPath());
            this.treeCat.setSelectionPath(path);
            this.treeCat.scrollPathToVisible(path);
            return true;
        }
        this.treeCat.setSelectionRow(0);
        return false;
    }

    private GalleryTreeNode getRoot() {
        return (GalleryTreeNode)this._treeModel.getRoot();
    }

    public void setContext(Context context) {
        this._context = context;
    }

    protected void setInitialSelection(String folderName, String className) {
        GalleryFolder folder;
        GalleryTreeNode next;
        Enumeration<TreeNode> e;
        GalleryTreeNode root = this.getRoot();
        if (folderName != null) {
            this._explicitInitialSel = true;
            e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                next = (GalleryTreeNode)e.nextElement();
                folder = (GalleryFolder)next.getUserObject();
                if (!folderName.equals(folder.getName())) continue;
                TreePath treePath = new TreePath(next.getPath());
                this.treeCat.setSelectionPath(treePath);
                this.treeCat.scrollPathToVisible(treePath);
                if (this.itemsList.getModel().getSize() > 0) {
                    this.itemsList.setSelectedIndex(0);
                }
                root = next;
                break;
            }
            this.jspTreeCat.getHorizontalScrollBar().setValue(0);
        }
        if (className != null) {
            this._explicitInitialSel = true;
            e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                GalleryElement[] elements;
                next = (GalleryTreeNode)e.nextElement();
                folder = (GalleryFolder)next.getUserObject();
                for (GalleryElement elem : elements = folder.getElementChildren()) {
                    String invokableClass = elem.getInvokableClass();
                    if (!className.equals(invokableClass)) continue;
                    this.treeCat.setSelectionPath(new TreePath(next.getPath()));
                    ListModel listModel = this.itemsList.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        if (!elem.equals(listModel.getElementAt(i))) continue;
                        this.itemsList.setSelectedIndex(i);
                        break;
                    }
                    return;
                }
            }
        }
    }

    GalleryElement getSelectedItem() {
        int index = this.itemsList.getSelectedIndex();
        if (index != -1) {
            return (GalleryElement)this.itemsList.getModel().getElementAt(index);
        }
        return null;
    }

    void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    int getMainDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    void shouldRefresh() {
        TreePath selectedPath;
        this.chkShowAllDescriptions.setSelected(this._model.isShowDescriptions());
        if (!this._explicitInitialSel && (selectedPath = this._model.getSelectedCategoryPath()) != null && !this.treeCat.getSelectionPath().equals(selectedPath) && this.restoreTreeSelection(selectedPath)) {
            this._persistLastSelectionIndex = true;
            this.restoreLastSelectedItem();
        }
    }

    private void restoreLastSelectedItem() {
        String savedItem = this._model.getLastSelectedItem();
        ListModel listModel = this.itemsList.getModel();
        int itemCount = listModel.getSize();
        boolean tryRestore = ModelUtil.hasLength((String)savedItem);
        if (tryRestore) {
            for (int i = 0; i < itemCount; ++i) {
                GalleryElement galleryItem = (GalleryElement)listModel.getElementAt(i);
                if (!ModelUtil.areEqual((Object)galleryItem.getName(), (Object)savedItem)) continue;
                this.itemsList.setSelectedIndex(i);
                this.scrollItemIntoView();
                return;
            }
        }
        if (itemCount > 0 && this.itemsList.isSelectionEmpty()) {
            if (tryRestore) {
                this._persistLastSelectionIndex = false;
            }
            this.itemsList.setSelectedIndex(0);
        }
    }

    private void persistLastSelectedItem() {
        GalleryElement element = this.getSelectedItem();
        if (element != null) {
            this._model.setLastSelectedItem(element.getName());
        }
    }

    private void setShowAllDescriptions(boolean showAllDescriptions) {
        this._model.setShowDescriptions(showAllDescriptions);
    }

    private void rebuildGallery() {
        this.treeCat.setModel(this.createTreeModel());
        if (this.treeCat.getRowCount() > 0) {
            TreePath selectedPath = this._model.getSelectedCategoryPath();
            if (selectedPath != null) {
                this.restoreTreeExpansion();
                this._persistLastSelectionIndex = this.restoreTreeSelection(selectedPath);
                this.jspTreeCat.getHorizontalScrollBar().setValue(0);
            } else {
                IdeUtil.expandAllTreeRows((JTree)this.treeCat);
                this.treeCat.setSelectionRow(0);
            }
        }
        this.restoreLastSelectedItem();
    }

    private void scrollItemIntoView() {
        int row = this.itemsList.getSelectedIndex();
        Rectangle rect = this.itemsList.getCellBounds(row, row);
        if (rect != null) {
            this.itemsList.scrollRectToVisible(rect);
        }
    }

    void addItemsListSelectionListener(ListSelectionListener listener) {
        if (listener != null) {
            this.itemsList.getSelectionModel().addListSelectionListener(listener);
        }
    }

    void removeItemsListSelectionListener(ListSelectionListener listener) {
        if (listener != null) {
            this.itemsList.getSelectionModel().removeListSelectionListener(listener);
        }
    }

    private void fireInvokeWizardAction(GalleryElement element) {
        if (element.isAvailable(this._context)) {
            Invokable invokable = element.getInvokable();
            if (invokable != null) {
                this.fireActionPerformed(invokable);
            } else {
                String message = GalleryArb.getString((int)1);
                String title = GalleryArb.getString((int)0);
                IdeMainWindow mainFrame = Ide.getMainWindow();
                MessageDialog.error((Component)mainFrame, (Object)message, (String)title, null);
            }
        }
    }

    private void fireActionPerformed(Invokable event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        String actionCommand = "ITEM_INVOKED";
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(event, 1001, actionCommand, 0);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    static final class NoResultsFoundPanel
    extends JPanel {
        final JLabel feedback;

        NoResultsFoundPanel() {
            super(new GridBagLayout());
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            GridBagConstraints g = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0);
            this.feedback = new JLabel();
            ResourceUtils.resLabel((JLabel)this.feedback, null, (String)GalleryArb.getString((int)19));
            this.add((Component)this.feedback, g);
            ++g.gridy;
            g.fill = 1;
            g.weighty = 1.0;
            ++g.gridy;
            this.add((Component)Box.createVerticalBox(), g);
        }
    }

    private final class GalleryTreeNode
    extends DefaultMutableTreeNode {
        public GalleryTreeNode(GalleryFolder folder, List<GalleryElement> children) {
            super(folder);
            Object[] folders = folder.getFolderChildren();
            Arrays.sort(folders);
            for (Object f : folders) {
                this.add(new GalleryTreeNode((GalleryFolder)f, children));
                if (children == null) continue;
                for (GalleryElement child : ((GalleryFolder)f).getElementChildren()) {
                    ObjectGalleryPanel.this._hierarchyMgr.setParentFolder(child, (GalleryFolder)f);
                    if (children.contains(child)) continue;
                    children.add(child);
                }
            }
        }

        private GalleryFolder getGalleryFolder() {
            return (GalleryFolder)this.getUserObject();
        }
    }

    private final class EventHandler
    implements ItemListener,
    HierarchyListener,
    ListSelectionListener,
    MouseListener,
    SearchListener,
    TreeExpansionListener,
    TreeSelectionListener {
        private volatile int _selectedItemTracker;

        private EventHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            boolean showDescriptions = checkBox.isSelected();
            ObjectGalleryPanel.this.setShowAllDescriptions(showDescriptions);
            int index = ObjectGalleryPanel.this.itemsList.getSelectedIndex();
            GalleryItemsListCellRenderer oldRenderer = (GalleryItemsListCellRenderer)ObjectGalleryPanel.this.itemsList.getCellRenderer();
            GalleryItemsListCellRenderer newRenderer = new GalleryItemsListCellRenderer(ObjectGalleryPanel.this._context, ObjectGalleryPanel.this._hierarchyMgr, showDescriptions);
            newRenderer.setShowCategory(oldRenderer.isShowCategory());
            ObjectGalleryPanel.this.itemsList.setCellRenderer(newRenderer);
            ObjectGalleryPanel.this.itemsList.setSelectedIndex(index);
            ObjectGalleryPanel.this.scrollItemIntoView();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent event) {
            ObjectGalleryPanel panel;
            if ((event.getChangeFlags() & 4L) != 0L && (panel = (ObjectGalleryPanel)event.getSource()).isShowing()) {
                int mainDividerLocation = ObjectGalleryPanel.this._model.getMainDividerLocation();
                if (mainDividerLocation != 0) {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(mainDividerLocation);
                } else {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(ObjectGalleryPanel.this.splitPane.getResizeWeight());
                }
                ObjectGalleryPanel.this.removeHierarchyListener(this);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            GalleryItemsListCellRenderer renderer = (GalleryItemsListCellRenderer)ObjectGalleryPanel.this.itemsList.getCellRenderer();
            int selIndex = ((DefaultListSelectionModel)e.getSource()).getMinSelectionIndex();
            renderer.setSelectedIndex(selIndex);
            if (!e.getValueIsAdjusting()) {
                GalleryElement element;
                if (!ObjectGalleryPanel.this._explicitInitialSel && ObjectGalleryPanel.this._persistLastSelectionIndex) {
                    ObjectGalleryPanel.this.persistLastSelectedItem();
                }
                ObjectGalleryPanel.this._persistLastSelectionIndex = true;
                if (DEBUG_GALLERY_ITEMS && (element = ObjectGalleryPanel.this.getSelectedItem()) != null) {
                    System.out.println(String.format("gallery item: %s [name=%s, id=%s]", element.getName(), element.getInvokableClass(), element.getId()));
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                int index = ObjectGalleryPanel.this.itemsList.getSelectedIndex();
                if (e.getClickCount() == 2) {
                    Object value;
                    if (index != this._selectedItemTracker) {
                        ObjectGalleryPanel.this.itemsList.setSelectedIndex(this._selectedItemTracker);
                        index = this._selectedItemTracker;
                    }
                    if ((value = ObjectGalleryPanel.this.itemsList.getModel().getElementAt(index)) instanceof GalleryElement) {
                        GalleryElement element = (GalleryElement)value;
                        ObjectGalleryPanel.this.fireInvokeWizardAction(element);
                    }
                } else if (e.getClickCount() == 1) {
                    this._selectedItemTracker = index;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            GalleryFolder folder = ObjectGalleryPanel.this.getGalleryFolder(e.getPath());
            folder.setExpanded(true);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            GalleryFolder folder = ObjectGalleryPanel.this.getGalleryFolder(e.getPath());
            folder.setExpanded(false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath();
            GalleryFolder selFolder = ObjectGalleryPanel.this.getGalleryFolder(selectedPath);
            this.registerDeferredItems(selFolder);
            GalleryItemsListModel listModel = new GalleryItemsListModel(selFolder);
            ObjectGalleryPanel.this.itemsList.setModel(listModel);
            GalleryItemsListCellRenderer tableCellRenderer = (GalleryItemsListCellRenderer)ObjectGalleryPanel.this.itemsList.getCellRenderer();
            tableCellRenderer.setShowCategory(selFolder == ObjectGalleryPanel.this._allItemsFolder);
            if (!ObjectGalleryPanel.this.treeCat.isShowing()) {
                return;
            }
            this.makeTableVisible();
            if (!ObjectGalleryPanel.this._explicitInitialSel) {
                ObjectGalleryPanel.this._model.setSelectedCategoryPath(selectedPath);
                ObjectGalleryPanel.this.persistLastSelectedItem();
            }
        }

        private void registerDeferredItems(GalleryFolder folder) {
            boolean mustRefreshAllItemsFolder = false;
            if (folder == ObjectGalleryPanel.this._allItemsFolder) {
                mustRefreshAllItemsFolder = ObjectGalleryPanel.this._model.registerAllDeferredItems();
            } else if (folder != null) {
                mustRefreshAllItemsFolder = ObjectGalleryPanel.this._model.registerDeferredItems(folder.getName());
            }
            if (mustRefreshAllItemsFolder) {
                ArrayList<GalleryElement> allElements = new ArrayList<GalleryElement>();
                new GalleryTreeNode(ObjectGalleryPanel.this._model, allElements);
                ObjectGalleryPanel.this._allItemsFolder.setChildrenDirectly(allElements);
            }
        }

        public void searchPerformed(SearchEvent se) {
            TreePath selectedPath;
            GalleryFolder selFolder;
            String searchText = se.getSearchText().trim();
            if (searchText.length() > 0 && (selFolder = ObjectGalleryPanel.this.getGalleryFolder(selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath())) != ObjectGalleryPanel.this._allItemsFolder) {
                TreePath path = new TreePath(new Object[]{ObjectGalleryPanel.this.getRoot(), ObjectGalleryPanel.this.getRoot().getLastChild()});
                ObjectGalleryPanel.this.treeCat.setSelectionPath(path);
                ObjectGalleryPanel.this.treeCat.scrollPathToVisible(path);
            }
            if ((selFolder = ObjectGalleryPanel.this.getGalleryFolder(selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath())) == ObjectGalleryPanel.this._allItemsFolder) {
                ObjectGalleryPanel.this._allItemsFolder.setSearchText(searchText);
                GalleryItemsListModel listModel = (GalleryItemsListModel)ObjectGalleryPanel.this.itemsList.getModel();
                Object[] preSearchElems = listModel.getGalleryElements();
                Object[] postSearchElems = ObjectGalleryPanel.this._allItemsFolder.getSortedElementChildren();
                if (!Arrays.equals(preSearchElems, postSearchElems)) {
                    listModel.fireContentsChanged(ObjectGalleryPanel.this.itemsList, 0, listModel.getSize() - 1);
                }
                if (listModel.getSize() > 0) {
                    ObjectGalleryPanel.this.itemsList.clearSelection();
                    ObjectGalleryPanel.this.itemsList.setSelectedIndex(0);
                    this.makeTableVisible();
                } else {
                    this.showNoResultsPanel();
                }
            }
        }

        private void makeTableVisible() {
            if (ObjectGalleryPanel.this.itemsList.getModel().getSize() > 0) {
                ObjectGalleryPanel.this.itemsList.setSelectedIndex(0);
            }
            ObjectGalleryPanel.this.jspListItems.setViewportView(ObjectGalleryPanel.this.itemsList);
        }

        private void showNoResultsPanel() {
            ObjectGalleryPanel.this.itemsList.getSelectionModel().clearSelection();
            ObjectGalleryPanel.this.jspListItems.setViewportView(ObjectGalleryPanel.this.noSearchResultsPanel);
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }
}

