/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.display.DisplayHtml;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class ReportHtmlDialog
implements ActionListener {
    private DisplayModel _model;
    private JEWTDialog _dialog;
    private DBConnectionComboBox _dbConnectionCombo;
    private JTextField _htmlFileField;
    private JButton _browseButton;
    private JCheckBox _includeTimeStamp;
    private JCheckBox _launchCheck;
    private Calendar _date;
    private static String lastDirectory;
    private static String lastConnectionName;
    private static boolean lastTimestampCheck;
    private static boolean lastLaunchCheck;

    public ReportHtmlDialog(ReportNode reportNode) {
        Serializable serializable;
        CharSequence charSequence;
        this._model = reportNode.getReport();
        this._date = Calendar.getInstance();
        this._date.setTime(new Date(System.currentTimeMillis()));
        String string = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this._model.getName().replace(" ", "").replace("\\", "").replace("/", "").replace(":", "").replace("*", "").replace("?", "").replace("\"", "").replace("<", "").replace(">", "").replace("|", ""));
            ((StringBuffer)charSequence).append("-");
            ((StringBuffer)charSequence).append(this._date.get(1) - 2000);
            ((StringBuffer)charSequence).append(this.pad(this._date.get(2)));
            ((StringBuffer)charSequence).append(this.pad(this._date.get(5)));
            ((StringBuffer)charSequence).append("-");
            ((StringBuffer)charSequence).append(this.pad(this._date.get(11)));
            ((StringBuffer)charSequence).append(this.pad(this._date.get(12)));
            ((StringBuffer)charSequence).append(this.pad(this._date.get(13)));
            string = URLEncoder.encode(((StringBuffer)charSequence).toString(), "UTF-8");
            serializable = new File(string);
            if (((File)serializable).exists()) {
                int n = 1;
                String string2 = string;
                while (((File)serializable).exists()) {
                    string = string2 + "_" + n++;
                    serializable = new File(string);
                }
            }
        }
        catch (Exception exception) {
            string = this._model.getName();
        }
        charSequence = ReportArb.getString("GENERATE_HTML_TITLE");
        serializable = this.getHtmlPanel(string);
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)serializable, null, (String)charSequence, (int)10);
        this._dialog.setMinimumSize(((JComponent)serializable).getPreferredSize());
        this._dialog.addActionListener((ActionListener)this);
        Dimension dimension = this._dialog.getPreferredSize();
        int n = (int)dimension.getHeight() + 50;
        int n2 = (int)dimension.getWidth() + 50;
        this._dialog.setSize(n2, n);
        this._dialog.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
    }

    private String pad(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    private JPanel getHtmlPanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._dbConnectionCombo = new DBConnectionComboBox();
        if (lastConnectionName != null) {
            this._dbConnectionCombo.setCurrentConnection(lastConnectionName);
        }
        JComboBox jComboBox = this._dbConnectionCombo.getJComboBox();
        this._htmlFileField = new JTextField(this.defaultHtmlPath(string));
        this._browseButton = new JButton(ReportArb.getString("BROWSE_LABEL"));
        this._includeTimeStamp = new JCheckBox(ReportArb.getString("INCLUDE_TIME_STAMP"));
        this._launchCheck = new JCheckBox(ReportArb.getString("LAUNCH_URI_LABEL"));
        this._includeTimeStamp.setSelected(lastTimestampCheck);
        this._launchCheck.setSelected(lastLaunchCheck);
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ReportHtmlDialog.this.promptHtmlFilePath(ReportHtmlDialog.this._htmlFileField.getText());
                if (string != null) {
                    ReportHtmlDialog.this._htmlFileField.setText(string);
                }
            }
        });
        jPanel.add((Component)new JLabel(ReportArb.getString("CONNECTION_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)jComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)new JLabel(ReportArb.getString("DEST_HTML_FILE_LABEL")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._htmlFileField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._includeTimeStamp, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._launchCheck, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return jPanel;
    }

    private String defaultHtmlPath(String string) {
        String string2 = lastDirectory;
        if (string2 == null) {
            string2 = System.getProperty("user.home");
        }
        if (string2 == null) {
            string2 = "";
        }
        File file = new File(string2);
        File file2 = new File(file, string + ".html");
        return file2.getAbsolutePath();
    }

    public boolean runDialog() {
        return WizardLauncher.runDialog((JDialog)this._dialog);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final File file = new File(this._htmlFileField.getText());
        final String string = this._dbConnectionCombo.getCurrentConnectionName();
        final String string2 = file.getParent();
        final boolean bl = this._includeTimeStamp.isSelected();
        final boolean bl2 = this._launchCheck.isSelected();
        if (this.resolveBinds(this._model.getQuery())) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(ReportArb.getString("GENERATING_HTML"), true, IRaptorTaskRunMode.MODAL){

                protected Void doWork() throws TaskException {
                    DateFormat dateFormat;
                    String string4 = null;
                    if (bl) {
                        dateFormat = DateFormat.getDateTimeInstance();
                        string4 = dateFormat.format(ReportHtmlDialog.this._date.getTime());
                    }
                    dateFormat = new DisplayHtml(file, string, ReportHtmlDialog.this._model, (Map)ReportHtmlDialog.this._model.getQuery().getBindValues(), string4);
                    IErrorHandler iErrorHandler = new IErrorHandler(){
                        private boolean hasErrors = false;

                        public void handleError(IErrorHandler.Category category, Throwable throwable) {
                            this.hasErrors = true;
                            ReportHtmlDialog.this.reportException(category, throwable);
                        }

                        public boolean hasErrors() {
                            return this.hasErrors;
                        }
                    };
                    dateFormat.generate(iErrorHandler);
                    String string22 = null;
                    if (!iErrorHandler.hasErrors() && bl2) {
                        if (!Desktop.isDesktopSupported()) {
                            string22 = ReportArb.getString("LAUNCH_BROWSER_NOT_SUPPORTED");
                        } else {
                            Desktop desktop = Desktop.getDesktop();
                            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                                string22 = ReportArb.getString("LAUNCH_BROWSER_NOT_SUPPORTED");
                            } else {
                                try {
                                    Desktop.getDesktop().browse(dateFormat.uri());
                                }
                                catch (Exception exception) {
                                    string22 = ReportArb.format("LAUNCH_BROWSER_ERROR", exception.getLocalizedMessage());
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                }
                            }
                            if (string22 != null) {
                                final String string3 = string22;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)ReportArb.getString("LAUNCH_BROWSER_FAILURE_TITLE"), null);
                                    }
                                });
                            }
                        }
                    }
                    if (iErrorHandler.hasErrors()) {
                        throw new TaskException(null);
                    }
                    lastConnectionName = string;
                    lastDirectory = string2;
                    lastTimestampCheck = bl;
                    lastLaunchCheck = bl2 && string22 == null;
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        this._dialog.dispose();
    }

    private void reportException(final IErrorHandler.Category category, final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (category) {
                    case FILE: {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ReportArb.format("HTML_FILE_FAILURE", throwable.getMessage()), (String)ReportArb.getString("HTML_GENERATION_ERROR"), null);
                        break;
                    }
                    case CONNECTION: {
                        Throwable throwable2 = throwable.getCause();
                        String string = throwable2 != null ? throwable2.getMessage() : throwable.getMessage();
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ReportArb.format("HTML_CONNECTION_FAILURE", string), (String)ReportArb.getString("HTML_GENERATION_ERROR"), null);
                        break;
                    }
                    case SQL: {
                        ExceptionHandler.handleException((Throwable)throwable);
                        break;
                    }
                    case OTHER: {
                        ExceptionHandler.handleException((Throwable)throwable);
                    }
                }
            }
        });
    }

    private boolean resolveBinds(Query query) {
        final boolean[] blArray = new boolean[]{false};
        if (query.getBinds().size() > 0) {
            BindInfo bindInfo = new BindInfo(query);
            HelpSystem.getHelpSystem().registerTopic((JComponent)bindInfo, "f1_bindnulldefault_html");
            final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)bindInfo, null, (String)Messages.getString((String)"DisplayPanel.BIND_TITLE"), (int)14);
            jEWTDialog.setDefaultButton(8);
            jEWTDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    blArray[0] = true;
                    jEWTDialog.dispose();
                }
            });
            jEWTDialog.pack();
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            WizardLauncher.runDialog((JDialog)jEWTDialog);
        } else {
            blArray[0] = true;
        }
        return blArray[0];
    }

    private String promptHtmlFilePath(String string) {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("HTML_FILES_FILTER"), "html"));
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("ALL_FILES_FILTER")));
        try {
            uRLFileChooser.setSelectedFile(new File(string));
        }
        catch (Exception exception) {
            return null;
        }
        uRLFileChooser.setFileSelectionMode(0);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), ReportArb.getString("SELECT_REPORT_HTML_FILE"));
        String string2 = null;
        if (n == 0) {
            string2 = uRLFileChooser.getSelectedFile().toString();
        }
        return string2;
    }

    static {
        lastTimestampCheck = false;
        lastLaunchCheck = true;
    }
}

