/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.format.ReportFonts;
import oracle.dbtools.raptor.format.ReportPatternInfo;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.dbtools.raptor.report.pdf.PDFDateTimeDialog;
import oracle.dbtools.raptor.report.pdf.PreserveStyledString;
import oracle.dbtools.raptor.report.pdf.Ruler;
import oracle.dbtools.raptor.report.pdf.StyleLocation;
import oracle.ide.Ide;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class PDFEditDialog
implements ActionListener {
    protected UndoManager undo = new UndoManager();
    protected MyCaretListener caretListener = new MyCaretListener();
    private JEWTDialog _dlg = null;
    private Toolbar _toolbar;
    private JTextPane _textPane;
    private JComboBox _font;
    private JComboBox _fontSize;
    private CustomColorChoice _fontColorChoice;
    private JButton _btnCut;
    private JButton _btnCopy;
    private JButton _btnPaste;
    private JButton _btnBold;
    private JButton _btnItalic;
    private JButton _btnUnderline;
    private JButton _btnDateTime;
    private JButton _btnPageNo;
    private ArrayList<ReportPatternInfo> _reportPatternList = null;
    private boolean _ignoreAction = false;
    private String _title;
    private String _fontPath;
    private String _prevFontName;
    private Integer _prevFontSize;
    private int _currRGB = -99999;
    private StyledDocument _styledDoc;
    private boolean _autoUpdateDate = false;

    public PDFEditDialog(String string, StyledDocument styledDocument, String string2) {
        this._title = string;
        this._styledDoc = styledDocument;
        this._fontPath = string2;
        this.initComponents();
    }

    private void initComponents() {
        String string;
        String[] stringArray;
        if (this._styledDoc instanceof AbstractDocument) {
            ((AbstractDocument)((Object)this._styledDoc)).setDocumentFilter(new DateTimeInsertsDocumentFilter());
        }
        int n = this._styledDoc.getLength();
        try {
            if (n > 0) {
                int n2 = n;
                while (n2 >= 0 && (stringArray = this._styledDoc.getText(0, this._styledDoc.getLength())).endsWith("\n")) {
                    this._styledDoc.remove(this._styledDoc.getLength() - 1, 1);
                    --n;
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this._textPane = new JTextPane();
        this._textPane.setDragEnabled(false);
        this._textPane.setTransferHandler(new PreserveStyleTransferHandler());
        this._textPane.setStyledDocument(this._styledDoc);
        this._textPane.setCaretPosition(0);
        this._textPane.moveCaretPosition(0);
        MutableAttributeSet mutableAttributeSet = null;
        if (this._textPane.getDocument().getLength() > 0) {
            mutableAttributeSet = this._textPane.getInputAttributes();
        }
        stringArray = ReportFonts.getAllFonts((String)this._fontPath);
        this._font = new JComboBox<String>(stringArray);
        if (mutableAttributeSet != null) {
            this._font.setSelectedItem(StyleConstants.getFontFamily(mutableAttributeSet));
        } else {
            string = ReportFonts.getDefaultFontName((String)this._fontPath);
            if (string == null) {
                string = (String)this._font.getItemAt(0);
            }
            try {
                this._font.setSelectedItem(string);
            }
            catch (Exception exception) {
                this._font.setSelectedIndex(0);
            }
        }
        string = (String)this._font.getSelectedItem();
        this._font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PDFEditDialog.this._ignoreAction) {
                    return;
                }
                String string = PDFEditDialog.this._font.getSelectedItem().toString();
                new StyledEditorKit.FontFamilyAction("font-family-" + string, string).actionPerformed(actionEvent);
                if (PDFEditDialog.this.isMaximumHeight("ERROR_FONT_NAME_MAXIMUM_HEIGHT", PDFEditDialog.this._textPane.getDocument().getLength(), true)) {
                    PDFEditDialog.this._font.setSelectedItem(PDFEditDialog.this._prevFontName);
                    return;
                }
                PDFEditDialog.this._prevFontName = (String)PDFEditDialog.this._font.getSelectedItem();
                PDFEditDialog.this._textPane.requestFocusInWindow();
            }
        });
        this._prevFontName = string;
        this._fontSize = new JComboBox<Integer>(PDFConstants.POINT_SIZE_LIST);
        if (mutableAttributeSet != null) {
            this._fontSize.setSelectedItem(StyleConstants.getFontSize(mutableAttributeSet));
        } else {
            this._fontSize.setSelectedItem(12);
        }
        this._fontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PDFEditDialog.this._ignoreAction) {
                    return;
                }
                Integer n = (Integer)PDFEditDialog.this._fontSize.getSelectedItem();
                new StyledEditorKit.FontSizeAction("font-size-" + n.toString(), n).actionPerformed(actionEvent);
                if (PDFEditDialog.this.isMaximumHeight("ERROR_FONT_SIZE_MAXIMUM_HEIGHT", PDFEditDialog.this._textPane.getDocument().getLength(), true)) {
                    PDFEditDialog.this._fontSize.setSelectedItem(PDFEditDialog.this._prevFontSize);
                    return;
                }
                PDFEditDialog.this._prevFontSize = (Integer)PDFEditDialog.this._fontSize.getSelectedItem();
                PDFEditDialog.this._textPane.requestFocusInWindow();
            }
        });
        this._prevFontSize = (Integer)this._fontSize.getSelectedItem();
        this._fontColorChoice = new CustomColorChoice();
        if (mutableAttributeSet != null) {
            this._fontColorChoice.setSelectedColor(new Color(StyleConstants.getForeground(mutableAttributeSet).getRGB()));
        } else {
            this._fontColorChoice.setSelectedColor(new Color(-16777216));
        }
        this._fontColorChoice.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PDFEditDialog.this._ignoreAction) {
                    return;
                }
                Color color = PDFEditDialog.this._fontColorChoice.getSelectedColor();
                if (color.getRGB() == PDFEditDialog.this._currRGB) {
                    return;
                }
                String string = "font-color-" + Integer.toString(color.getRGB());
                new StyledEditorKit.ForegroundAction(string, color).actionPerformed(null);
                PDFEditDialog.this._currRGB = color.getRGB();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PDFEditDialog.this._textPane.requestFocusInWindow();
                    }
                });
            }
        });
        Font font = new Font(string, 0, 12);
        this._textPane.setFont(font);
        this._btnBold = new JButton();
        this._btnBold.setAction(new StyledEditorKit.BoldAction());
        this._btnBold.setIcon(PDFArb.getIcon("BOLD_ICON"));
        this._btnBold.setToolTipText(PDFArb.getString("BOLD"));
        this._btnBold.setText(null);
        this._btnItalic = new JButton();
        this._btnItalic.setAction(new StyledEditorKit.ItalicAction());
        this._btnItalic.setIcon(PDFArb.getIcon("ITALIC_ICON"));
        this._btnItalic.setToolTipText(PDFArb.getString("ITALIC"));
        this._btnItalic.setText(null);
        this._btnUnderline = new JButton();
        this._btnUnderline.setAction(new StyledEditorKit.UnderlineAction());
        this._btnUnderline.setIcon(PDFArb.getIcon("UNDERLINE_ICON"));
        this._btnUnderline.setToolTipText(PDFArb.getString("UNDERLINE"));
        this._btnUnderline.setText(null);
        this._btnDateTime = new JButton();
        this._btnDateTime.addActionListener(this);
        this._btnDateTime.setIcon(PDFArb.getIcon("DATETIME_ICON"));
        this._btnDateTime.setToolTipText(PDFArb.getString("INSERT_DATE"));
        this._btnPageNo = new JButton();
        this._btnPageNo.addActionListener(this);
        this._btnPageNo.setIcon(PDFArb.getIcon("PAGENUMBER_ICON"));
        this._btnPageNo.setToolTipText(PDFArb.getString("INSERT_PAGE"));
        this._btnCut = new JButton();
        this._btnCut.setAction(new DefaultEditorKit.CutAction());
        this._btnCut.setIcon(OracleIcons.getIcon((String)"cut.png"));
        this._btnCut.setToolTipText(PDFArb.getString("CUT"));
        this._btnCut.setText("Cut");
        this._btnCopy = new JButton();
        this._btnCopy.setAction(new DefaultEditorKit.CopyAction());
        this._btnCopy.setIcon(OracleIcons.getIcon((String)"copy.png"));
        this._btnCopy.setToolTipText(PDFArb.getString("COPY"));
        this._btnCopy.setText("Copy");
        this._btnPaste = new JButton();
        this._btnPaste.setAction(new DefaultEditorKit.PasteAction());
        this._btnPaste.setIcon(OracleIcons.getIcon((String)"paste.png"));
        this._btnPaste.setToolTipText(PDFArb.getString("PASTE"));
        this._btnPaste.setText("Paste");
        this._reportPatternList = new ArrayList();
        this._styledDoc.addUndoableEditListener(new MyUndoableEditListener());
        this._textPane.addCaretListener(this.caretListener);
    }

    private JPanel getPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._font, (String)PDFArb.getString("FONT"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._fontSize, (String)PDFArb.getString("SIZE"));
        int n = 0;
        int n2 = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 6, 8), 0, 0));
        jPanel2.add((Component)this._font, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 6, 16), 0, 0));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 6, 8), 0, 0));
        jPanel2.add((Component)this._fontSize, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 6, 16), 0, 0));
        jPanel2.add((Component)this._fontColorChoice, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 6, 6), 0, 0));
        this._toolbar = new Toolbar();
        this._toolbar.setFloatable(false);
        this._toolbar.add((Component)this._btnCut);
        this._toolbar.add((Component)this._btnCopy);
        this._toolbar.add((Component)this._btnPaste);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this._btnBold);
        this._toolbar.add((Component)this._btnItalic);
        this._toolbar.add((Component)this._btnUnderline);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)jPanel2);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this._btnDateTime);
        this._toolbar.add((Component)this._btnPageNo);
        Ruler ruler = new Ruler(0, false);
        Ruler ruler2 = new Ruler(1, false);
        ruler.setPreferredWidth(1000);
        ruler2.setPreferredHeight(1000);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(this._textPane);
        JScrollPane jScrollPane = new JScrollPane(jPanel3);
        jScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.black));
        jScrollPane.setColumnHeaderView(ruler);
        jScrollPane.setRowHeaderView(ruler2);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", new Corner());
        jScrollPane.setCorner("LOWER_LEFT_CORNER", new Corner());
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", new Corner());
        jPanel.add((Component)this._toolbar, "First");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public JTextPane getTextPane() {
        return this._textPane;
    }

    public void setAutoUpdateDate(boolean bl) {
        this._autoUpdateDate = bl;
    }

    public boolean isAutoUpdateDate() {
        return this._autoUpdateDate;
    }

    public void setReportPatternList(ArrayList<ReportPatternInfo> arrayList) {
        if (arrayList != null && !arrayList.isEmpty()) {
            this._reportPatternList = new ArrayList();
            this._reportPatternList.addAll(arrayList);
        }
    }

    public ArrayList<ReportPatternInfo> getReportPatternList() {
        return this._reportPatternList;
    }

    public boolean runDialog() {
        JPanel jPanel = this.getPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_editheaderfooter_html");
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, (Component)this._textPane, (String)this._title, (int)7);
        this._dlg.setModal(true);
        this._dlg.pack();
        this._dlg.setMinimumSize(new Dimension(750, 390));
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dlg);
        boolean bl = WizardLauncher.runDialog((JDialog)this._dlg);
        this._textPane.removeCaretListener(this.caretListener);
        if (!bl) {
            while (this.undo.canUndo()) {
                this.undo.undo();
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._btnDateTime) {
            this.processInsertDate();
        } else if (actionEvent.getSource() == this._btnPageNo) {
            this.processInsertPageNo();
        }
    }

    private void processInsertDate() {
        int n = this._textPane.getCaretPosition();
        if (!this.validPosition(n)) {
            Object[] objectArray = new Object[]{PDFArb.getString("DATE")};
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)PDFArb.format("INVALID_INSERT", objectArray), (String)this._title, null);
            this._textPane.requestFocusInWindow();
            return;
        }
        PDFDateTimeDialog pDFDateTimeDialog = new PDFDateTimeDialog(this._autoUpdateDate);
        if (pDFDateTimeDialog.runDialog()) {
            try {
                this._textPane.getDocument().insertString(n, pDFDateTimeDialog.getDateTimeValue(), this._textPane.getInputAttributes());
                this._textPane.requestFocusInWindow();
                this.setAutoUpdateDate(pDFDateTimeDialog._isAutoUpdateDate());
                if (this.isAutoUpdateDate()) {
                    ReportPatternInfo reportPatternInfo = new ReportPatternInfo(n, pDFDateTimeDialog.getDateTimePattern(), pDFDateTimeDialog.getDateTimeValue());
                    this._reportPatternList.add(reportPatternInfo);
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
            }
        }
    }

    private void processInsertPageNo() {
        int n = this._textPane.getCaretPosition();
        if (!this.validPosition(n)) {
            Object[] objectArray = new Object[]{PDFArb.getString("PAGE")};
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)PDFArb.format("INVALID_INSERT", objectArray), (String)this._title, null);
            this._textPane.requestFocusInWindow();
            return;
        }
        try {
            this._textPane.getDocument().insertString(n, PDFArb.getString("PAGE_FMT_NUM"), this._textPane.getInputAttributes());
            this._textPane.requestFocusInWindow();
            ReportPatternInfo reportPatternInfo = new ReportPatternInfo(n, "#", PDFArb.getString("PAGE_FMT_NUM"));
            this._reportPatternList.add(reportPatternInfo);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private boolean validPosition(int n) {
        if (this._reportPatternList.isEmpty()) {
            return true;
        }
        int n2 = 0;
        for (ReportPatternInfo reportPatternInfo : this._reportPatternList) {
            int n3 = reportPatternInfo.getPosition() + 1;
            n2 = reportPatternInfo.getPosition() + reportPatternInfo.getText().length() - 1;
            if (n < n3 || n > n2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareFontValues(int n, int n2) {
        try {
            MutableAttributeSet mutableAttributeSet = this._textPane.getInputAttributes();
            this._ignoreAction = true;
            if ((String)this._font.getSelectedItem() != StyleConstants.getFontFamily(mutableAttributeSet)) {
                this._font.setSelectedItem(StyleConstants.getFontFamily(mutableAttributeSet));
            }
            if ((Integer)this._fontSize.getSelectedItem() != StyleConstants.getFontSize(mutableAttributeSet)) {
                this._fontSize.setSelectedItem(StyleConstants.getFontSize(mutableAttributeSet));
            }
            if (this._fontColorChoice.getSelectedColor().getRGB() != StyleConstants.getForeground(mutableAttributeSet).getRGB()) {
                this._fontColorChoice.setSelectedColor(new Color(StyleConstants.getForeground(mutableAttributeSet).getRGB()));
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._ignoreAction = false;
        }
    }

    private boolean isMaximumHeight(String string, int n, boolean bl) {
        int n2 = 0;
        try {
            Rectangle rectangle = this._textPane.modelToView(n);
            n2 = rectangle.y + rectangle.height;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (n2 > 216) {
            if (bl && this.undo.canUndo()) {
                this.undo.undo();
            }
            Toolkit.getDefaultToolkit().beep();
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)PDFArb.getString(string), (String)this._title, null);
            this._textPane.requestFocusInWindow();
            return true;
        }
        return false;
    }

    protected class PreserveStyleTransferHandler
    extends TransferHandler {
        private static final String m_mimeType = "application/x-java-jvm-local-objectref;class=oracle.dbtools.raptor.report.pdf.PreserveStyledString";
        private DataFlavor m_dataFlavor;

        public PreserveStyleTransferHandler() {
            try {
                this.m_dataFlavor = new DataFlavor(m_mimeType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
            }
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!dataFlavor.equals(this.m_dataFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            JTextPane jTextPane = (JTextPane)jComponent;
            int n = jTextPane.getSelectionStart();
            int n2 = jTextPane.getSelectionEnd();
            PreserveStyledString preserveStyledString = new PreserveStyledString("");
            if (n != -1 && n != n2) {
                String string = jTextPane.getSelectedText();
                preserveStyledString = new PreserveStyledString(string);
                StyledDocument styledDocument = jTextPane.getStyledDocument();
                this.extractAttributes(styledDocument, n, n2, preserveStyledString);
            }
            return new PreserveStyledStringTransferable(preserveStyledString);
        }

        private void extractAttributes(StyledDocument styledDocument, int n, int n2, PreserveStyledString preserveStyledString) {
            int n3 = n;
            preserveStyledString.setLogicalStyle(styledDocument.getLogicalStyle(n3));
            while (n3 < n2) {
                Element element = styledDocument.getCharacterElement(n3);
                AttributeSet attributeSet = element.getAttributes();
                int n4 = element.getEndOffset();
                int n5 = n4 < n2 ? n4 : n2;
                preserveStyledString.addAttributes(attributeSet, n3, n5);
                n3 = n5;
            }
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            super.exportToClipboard(jComponent, clipboard, n);
            this.exportDone(jComponent, clipboard, n);
        }

        public void exportDone(JComponent jComponent, Clipboard clipboard, int n) {
            JTextPane jTextPane = (JTextPane)jComponent;
            if (n == 2) {
                int n2 = jTextPane.getSelectionStart();
                int n3 = jTextPane.getSelectionEnd() - n2;
                StyledDocument styledDocument = jTextPane.getStyledDocument();
                try {
                    styledDocument.remove(n2, n3);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
            }
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                PreserveStyledString preserveStyledString = null;
                try {
                    int n;
                    preserveStyledString = (PreserveStyledString)transferable.getTransferData(this.m_dataFlavor);
                    List<AttributeSet> list = preserveStyledString.getAttributeSets();
                    List<StyleLocation> list2 = preserveStyledString.getStyleLocations();
                    JTextPane jTextPane = (JTextPane)jComponent;
                    int n2 = n = jTextPane.getCaretPosition();
                    StyledDocument styledDocument = jTextPane.getStyledDocument();
                    try {
                        styledDocument.insertString(n, preserveStyledString.getText(), preserveStyledString.getLogicalStyle());
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        AttributeSet attributeSet = list.get(i);
                        StyleLocation styleLocation = list2.get(i);
                        if (StyleConstants.getComponent(attributeSet) != null) {
                            jTextPane.setSelectionStart(n);
                            jTextPane.setSelectionEnd(n + 1);
                            jTextPane.replaceSelection("");
                            jTextPane.setCaretPosition(n);
                            jTextPane.insertComponent(StyleConstants.getComponent(attributeSet));
                        } else {
                            styledDocument.setCharacterAttributes(n, styleLocation.getLength(), attributeSet, false);
                        }
                        n += styleLocation.getLength();
                    }
                    jTextPane.setCaretPosition(n2);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
            return false;
        }

        protected class PreserveStyledStringTransferable
        implements Transferable {
            private PreserveStyledString m_preserveStr;

            PreserveStyledStringTransferable(PreserveStyledString preserveStyledString) {
                this.m_preserveStr = preserveStyledString;
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.m_preserveStr;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{PreserveStyleTransferHandler.this.m_dataFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return PreserveStyleTransferHandler.this.m_dataFlavor.equals(dataFlavor);
            }

            public String toString() {
                return "PreserveStyledStringTransferable: " + this.m_preserveStr;
            }
        }
    }

    private class Corner
    extends JComponent {
        private Corner() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(PDFConstants.RULER_COLOR);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected class DateTimeInsertsDocumentFilter
    extends DocumentFilter {
        protected DateTimeInsertsDocumentFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            int n3;
            if (PDFEditDialog.this._reportPatternList == null || PDFEditDialog.this._reportPatternList.isEmpty()) {
                super.remove(filterBypass, n, n2);
                return;
            }
            int n4 = 0;
            int n5 = n;
            int n6 = n + n2;
            int n7 = 0;
            ArrayList<ReportPatternInfo> arrayList = new ArrayList<ReportPatternInfo>();
            for (ReportPatternInfo reportPatternInfo : PDFEditDialog.this._reportPatternList) {
                n3 = reportPatternInfo.getPosition();
                n7 = reportPatternInfo.getPosition() + reportPatternInfo.getText().length();
                if (n <= n3 && n6 >= n7) {
                    arrayList.add(reportPatternInfo);
                    continue;
                }
                if (n < n3 && n6 > n3 && n6 < n7) {
                    arrayList.add(reportPatternInfo);
                    n4 = n4 + (n7 - n6) + n2;
                    continue;
                }
                if (n < n3 || n >= n7) continue;
                arrayList.add(reportPatternInfo);
                n5 = n3;
                n4 = reportPatternInfo.getText().length();
            }
            if (n4 == 0) {
                n4 = n2;
            }
            super.remove(filterBypass, n5, n4);
            if (!arrayList.isEmpty()) {
                PDFEditDialog.this._reportPatternList.removeAll(arrayList);
            }
            for (ReportPatternInfo reportPatternInfo : PDFEditDialog.this._reportPatternList) {
                n3 = reportPatternInfo.getPosition();
                if (n3 <= n) continue;
                reportPatternInfo.setPosition(n3 - n4);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (PDFEditDialog.this.isMaximumHeight("ERROR_MAXIMUM_HEIGHT", filterBypass.getDocument().getLength(), true)) {
                return;
            }
            super.insertString(filterBypass, n, string, attributeSet);
            int n2 = 0;
            int n3 = 0;
            for (ReportPatternInfo reportPatternInfo : PDFEditDialog.this._reportPatternList) {
                n2 = reportPatternInfo.getPosition();
                n3 = n2 + string.length();
                if (n2 < n) continue;
                reportPatternInfo.setPosition(n3);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            int n3;
            if (PDFEditDialog.this.isMaximumHeight("ERROR_MAXIMUM_HEIGHT", filterBypass.getDocument().getLength(), true)) {
                return;
            }
            if (PDFEditDialog.this._reportPatternList.isEmpty()) {
                super.replace(filterBypass, n, n2, string, attributeSet);
                if (string.contains("\n") && string.length() > 1 && PDFEditDialog.this.isMaximumHeight("ERROR_MAXIMUM_HEIGHT", filterBypass.getDocument().getLength(), true)) {
                    return;
                }
                return;
            }
            if (string.contains("\n") && string.length() > 1) {
                super.replace(filterBypass, n, n2, string, attributeSet);
                if (PDFEditDialog.this.isMaximumHeight("ERROR_MAXIMUM_HEIGHT", filterBypass.getDocument().getLength(), true)) {
                    return;
                }
                if (PDFEditDialog.this.undo.canUndo()) {
                    PDFEditDialog.this.undo.undo();
                }
            }
            int n4 = filterBypass.getDocument().getLength();
            int n5 = n2;
            int n6 = n;
            int n7 = n + n2;
            int n8 = 0;
            ArrayList<ReportPatternInfo> arrayList = new ArrayList<ReportPatternInfo>();
            for (ReportPatternInfo reportPatternInfo : PDFEditDialog.this._reportPatternList) {
                n3 = reportPatternInfo.getPosition();
                n8 = reportPatternInfo.getPosition() + reportPatternInfo.getText().length();
                if (n == n3 && n2 == 0 || n == n8 && n2 == 0) continue;
                if (n <= n3 && n7 >= n8) {
                    arrayList.add(reportPatternInfo);
                    continue;
                }
                if (n < n3 && n7 > n3 && n7 < n8) {
                    arrayList.add(reportPatternInfo);
                    n5 += n8 - n7;
                    continue;
                }
                if (n <= n3 || n >= n8) continue;
                arrayList.add(reportPatternInfo);
                n5 += n - n3;
                n6 = n3;
                if (n8 - n <= n2) continue;
                n5 += n8 - n;
            }
            super.replace(filterBypass, n6, n5, string, attributeSet);
            if (!arrayList.isEmpty()) {
                PDFEditDialog.this._reportPatternList.removeAll(arrayList);
            }
            if (!PDFEditDialog.this._reportPatternList.isEmpty()) {
                int n9 = n4 + string.length() - n5;
                int n10 = 0;
                if (n9 > n4) {
                    n10 = n9 - n4;
                } else if (n9 < n4) {
                    n10 = (n4 - n9) * -1;
                }
                for (ReportPatternInfo reportPatternInfo : PDFEditDialog.this._reportPatternList) {
                    n3 = reportPatternInfo.getPosition();
                    if (n3 < n) continue;
                    reportPatternInfo.setPosition(n3 + n10);
                }
            }
        }
    }

    protected class MyCaretListener
    implements CaretListener {
        protected MyCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.checkFontSelection(caretEvent.getDot(), caretEvent.getMark());
        }

        protected void checkFontSelection(final int n, final int n2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        PDFEditDialog.this.compareFontValues(n, n2);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        PDFEditDialog.this._ignoreAction = false;
                    }
                }
            });
        }
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            PDFEditDialog.this.undo.addEdit(undoableEditEvent.getEdit());
        }
    }
}

