/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.jgit.DelegatingProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.TransportCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class FetchCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> refSpecs;
    private final String remote;
    private Map<String, GitTransportUpdate> updates;
    private FetchResult result;

    public FetchCommand(Repository repository, GitClassFactory gitFactory, String remoteName, ProgressMonitor monitor) {
        this(repository, gitFactory, remoteName, Collections.emptyList(), monitor);
    }

    public FetchCommand(Repository repository, GitClassFactory gitFactory, String remote, List<String> fetchRefSpecifications, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.refSpecs = fetchRefSpecifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        Repository repository = this.getRepository();
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>(this.refSpecs.size());
        for (String refSpec : this.refSpecs) {
            specs.add(new RefSpec(refSpec));
        }
        try (Transport transport = null;){
            transport = this.openTransport(false);
            transport.setRemoveDeletedRefs(false);
            transport.setDryRun(false);
            transport.setFetchThin(true);
            transport.setTagOpt(TagOpt.FETCH_TAGS);
            this.result = transport.fetch((org.eclipse.jgit.lib.ProgressMonitor)new DelegatingProgressMonitor(this.monitor), specs);
            for (String msg : this.result.getMessages().split("\n")) {
                if (msg.isEmpty()) continue;
            }
            this.updates = new HashMap<String, GitTransportUpdate>(this.result.getTrackingRefUpdates().size());
            for (TrackingRefUpdate update : this.result.getTrackingRefUpdates()) {
                GitTransportUpdate upd = this.getClassFactory().createTransportUpdate(transport.getURI(), update);
                this.updates.put(upd.getLocalName(), upd);
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git fetch ").append(this.remote);
        for (String refSpec : this.refSpecs) {
            sb.append(' ').append(refSpec);
        }
        return sb.toString();
    }

    public Map<String, GitTransportUpdate> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public FetchResult getResult() {
        return this.result;
    }
}

