/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SubjectAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectAltName;
    private Vector subjAltName = new Vector();

    public SubjectAltNameExtension() {
        super(TYPE);
    }

    public SubjectAltNameExtension(GeneralName subjAltName) {
        this(subjAltName, false);
    }

    public SubjectAltNameExtension(GeneralName subjAltName, boolean critical) {
        super(TYPE, critical);
        this.subjAltName.addElement(subjAltName);
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(Vector subjAltName) {
        this(subjAltName, false);
    }

    public SubjectAltNameExtension(Vector subjAltName, boolean critical) {
        super(TYPE, critical);
        this.subjAltName = subjAltName;
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(InputStream is) throws IOException {
        super(is);
    }

    public Enumeration subjectAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.subjAltName.elements();
    }

    public void addSubjectAltName(GeneralName name) {
        this.subjAltName.addElement(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.subjAltName));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.subjAltName = new Vector();
            while (sis.hasMoreData()) {
                this.subjAltName.addElement(new GeneralName((InputStream)sis));
            }
            sis.terminate();
            if (this.subjAltName.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("subjectAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.subjAltName != null) {
            s.append("subjectAltNames = {");
            boolean mid = false;
            int size = this.subjAltName.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((GeneralName)this.subjAltName.elementAt(i)).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

