/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public class Entity
implements Externalizable {
    private String name;

    public Entity() {
    }

    public Entity(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((Entity)obj).getName());
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(new ASN1String(this.name));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.name = ASN1String.inputValue((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

