/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverFlavor;
import oracle.ideimpl.peek.PeekHookHandler;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;

public final class HoverOptions
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.ide.hover.HoverOptions";
    private static final String flavorPattern = "%s-%s";
    private static final String HOVER_ACTIVATOR = "flavorShortcut";
    private static final String FLAVOR_SMART_ENABLED = "flavorEnabled";
    private static final String HOVER_PRIORITY = "flavorPriority";
    private static final String SMART_ENABLED = "smartEnabled";
    private static final String SMART_ACTIVATOR = "smartShortcut";
    private static final String MULTI_SELECT_ACTIVATOR = "multiSelectShortcut";
    private static final EnumSet<HoverActivator.Modifier> defaultMultiSelectMods = EnumSet.of(HoverActivator.Modifier.CONTROL, HoverActivator.Modifier.SHIFT);
    private static final HoverActivator defaultMultiSelectActivator = new HoverActivator(defaultMultiSelectMods);

    private HoverOptions(HashStructure hash) {
        super(hash);
    }

    public static HoverOptions getInstance(PropertyStorage prefs) {
        HoverOptions options = new HoverOptions(HoverOptions.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
        return options;
    }

    private static String getFlavorName(String property, HoverFlavor hoverFlavor) {
        return String.format(flavorPattern, property, hoverFlavor.getName());
    }

    public HoverActivator getFlavorActivator(HoverFlavor hoverFlavor) {
        PeekHookHandler.get().updateOptions();
        String modifers = this._hash.getString(HoverOptions.getFlavorName(HOVER_ACTIVATOR, hoverFlavor), HoverActivator.Modifier.NONE.name());
        return new HoverActivator(modifers);
    }

    public void setFlavorActivator(HoverFlavor hoverFlavor, HoverActivator hoverActivator) {
        this._hash.putString(HoverOptions.getFlavorName(HOVER_ACTIVATOR, hoverFlavor), hoverActivator.toString());
    }

    public boolean isFlavorSmartEnabled(HoverFlavor hoverFlavor) {
        return this._hash.getBoolean(HoverOptions.getFlavorName(FLAVOR_SMART_ENABLED, hoverFlavor), true);
    }

    public void setFlavorSmartEnabled(HoverFlavor hoverFlavor, boolean isEnabled) {
        this._hash.putBoolean(HoverOptions.getFlavorName(FLAVOR_SMART_ENABLED, hoverFlavor), isEnabled);
    }

    public List<HoverFlavor> getFlavorPriority() {
        PeekHookHandler.get().updateOptions();
        ListStructure idList = this._hash.getListStructure(HOVER_PRIORITY);
        if (idList == null) {
            return Collections.EMPTY_LIST;
        }
        PeekHookHandler handler = PeekHookHandler.get();
        ArrayList<HoverFlavor> list = new ArrayList<HoverFlavor>();
        for (String id : idList) {
            HoverFlavor flavor = handler.getFlavor(id);
            if (flavor == null || list.contains(flavor)) continue;
            list.add(flavor);
        }
        return list;
    }

    public void setFlavorPriority(List<HoverFlavor> flavorList) {
        if (flavorList == null || flavorList.isEmpty()) {
            return;
        }
        ListStructure list = ListStructure.newInstance();
        for (HoverFlavor flavor : flavorList) {
            if (list.contains((Object)flavor)) continue;
            list.add((Object)flavor.getId());
        }
        this._hash.putListStructure(HOVER_PRIORITY, list);
    }

    public boolean isSmartEnabled() {
        PeekHookHandler.get().updateOptions();
        return this._hash.getBoolean(SMART_ENABLED, false);
    }

    public void setSmartEnabled(boolean isEnabled) {
        this._hash.putBoolean(SMART_ENABLED, isEnabled);
    }

    public HoverActivator getSmartActivator() {
        String modifers = this._hash.getString(SMART_ACTIVATOR, HoverActivator.Modifier.NONE.name());
        return new HoverActivator(modifers);
    }

    public void setSmartActivator(HoverActivator hoverActivator) {
        this._hash.putString(SMART_ACTIVATOR, hoverActivator.toString());
    }

    public HoverActivator getMultiSelectActivator() {
        String modifers = this._hash.getString(MULTI_SELECT_ACTIVATOR, defaultMultiSelectActivator.toString());
        return new HoverActivator(modifers);
    }

    public void setMultiSelectActivator(HoverActivator hoverActivator) {
        this._hash.putString(MULTI_SELECT_ACTIVATOR, hoverActivator.toString());
        String mod = hoverActivator.toKeyEventNameString();
        EditorProperties editorProperties = EditorProperties.getProperties();
        editorProperties.putProperty("caret-multi-caret-key-modifier", (Object)mod);
    }
}

