/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.model.ImageNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.util.Pair;

public final class PeekHelper {
    public static CodePeek createCodePeek(JComponent comp, String fileName, String text, String labelText, Rectangle rect) {
        if (text == null) {
            return null;
        }
        CodePeek peek = null;
        peek = new CodePeek(comp, fileName);
        rect.grow(1, 0);
        rect.translate(-1, -1);
        rect.x = Math.max(rect.x, 0);
        rect.y = Math.max(rect.y, 0);
        peek.setRectangle(rect);
        peek.setText(text);
        peek.setLabelText(labelText);
        return peek;
    }

    public static Peek createPeek(URL url, JComponent comp, Rectangle rect) {
        return PeekHelper.createPeek(url, comp, rect, -1, -1, null);
    }

    public static Peek createPeek(URL url, JComponent comp, Rectangle rect, int line, int padLines, String styleName) {
        Node node;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        boolean opened = false;
        if (node != null && !node.isOpen()) {
            try {
                node.open();
                opened = true;
            }
            catch (IOException e) {
                node = null;
            }
        }
        Peek peek = null;
        if (node instanceof TextNode) {
            opened = false;
            peek = PeekHelper.createTextPeek((TextNode)node, comp, rect, line, padLines, styleName);
        } else if (node instanceof ImageNode) {
            peek = PeekHelper.createImagePeek((ImageNode)node, comp, rect);
        }
        if (peek != null) {
            peek.setLabelIcon(node.getIcon());
        }
        if (opened && node != null) {
            try {
                node.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return peek;
    }

    public static Peek createTextPeek(TextNode textNode, JComponent comp, Rectangle rect) {
        return PeekHelper.createTextPeek(textNode, comp, rect, -1, -1, null);
    }

    public static Peek createTextPeek(TextNode textNode, JComponent comp, Rectangle rect, int line, int padLines, String styleName) {
        String text = PeekHelper.getPeekText(textNode.getURL(), line, padLines);
        CodePeek peek = PeekHelper.createCodePeek(comp, textNode.getShortLabel(), text, textNode.getShortLabel(), rect);
        if (peek != null || styleName != null) {
            HighlightLayer hl = peek.getEditor().createHighlightLayer();
            int hiLine = line < padLines ? line : padLines;
            HighlightStyle style = EditorProperties.getProperties().getHighlightRegistry().lookupStyle(styleName);
            hl.addLineHighlight(style, hiLine);
        }
        return peek;
    }

    public static Peek createImagePeek(ImageNode node, JComponent comp, Rectangle rect) {
        Image image = node.getImage();
        if (image != null) {
            JLabel imageLabel = new JLabel(new ImageIcon(image));
            imageLabel.setOpaque(true);
            imageLabel.setBackground(Color.WHITE);
            imageLabel.putClientProperty(UIConstants.VETO_CONVERSION, true);
            Peek peek = new Peek(comp, imageLabel);
            peek.setRectangle(rect);
            return peek;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPeekText(URL url, int line, int padLines) {
        Node node;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        boolean opened = false;
        if (!node.isOpen()) {
            try {
                node.open();
                opened = true;
            }
            catch (IOException e) {
                node = null;
            }
        }
        String text = "";
        Reader reader = null;
        try {
            if (node instanceof TextNode) {
                TextNode tNode = (TextNode)node;
                try {
                    reader = tNode.getReader();
                    opened = false;
                }
                catch (IOException e) {
                    reader = null;
                }
            }
            text = line == -1 ? PeekHelper.readWholeNode(reader) : PeekHelper.readText(reader, line, padLines);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        if (opened) {
            try {
                node.close();
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return text;
    }

    public static void addHighlight(CodePeek peek, int line, String styleName) {
        HighlightLayer hl = peek.getEditor().createHighlightLayer();
        EditorProperties properties = EditorProperties.getProperties();
        HighlightStyle style = properties.getHighlightRegistry().lookupStyle(styleName);
        hl.addLineHighlight(style, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, Integer> getPeekTextByOffset(URL url, int offset, int padLines) {
        Node node;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        boolean opened = false;
        if (!node.isOpen()) {
            try {
                node.open();
                opened = true;
            }
            catch (IOException e) {
                node = null;
            }
        }
        Pair<String, Integer> ret = new Pair<String, Integer>(null, (Object)0);
        Reader reader = null;
        try {
            if (node instanceof TextNode) {
                TextNode tNode = (TextNode)node;
                try {
                    reader = tNode.getReader();
                    opened = false;
                }
                catch (IOException e) {
                    reader = null;
                }
            }
            ret = PeekHelper.readTextOffset(reader, offset, padLines);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        if (opened) {
            try {
                node.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<String, Integer> readTextOffset(Reader r, int offset, int padLines) {
        StringBuffer sb = new StringBuffer();
        int lines = padLines + 1;
        int curOffset = 0;
        int curLine = 0;
        LinkedList<String> lineList = new LinkedList<String>();
        try {
            r = new BufferedReader(r);
            String aLine = ((BufferedReader)r).readLine();
            while (aLine != null) {
                aLine = aLine + "\n";
                lineList.addLast(aLine);
                if (lineList.size() > lines) {
                    lineList.removeFirst();
                }
                if ((curOffset += aLine.length()) > offset) break;
                aLine = ((BufferedReader)r).readLine();
                ++curLine;
            }
            aLine = ((BufferedReader)r).readLine();
            for (int endPad = 0; aLine != null && endPad < padLines; ++endPad) {
                aLine = aLine + "\n";
                lineList.addLast(aLine);
                aLine = ((BufferedReader)r).readLine();
            }
            for (String line : lineList) {
                sb.append(line);
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        catch (IOException aLine) {
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException aLine) {}
        }
        String text = sb.length() > 0 ? sb.toString() : null;
        return new Pair((Object)text, (Object)curLine);
    }

    public static String getPeekText(URL url) {
        return PeekHelper.getPeekText(url, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readWholeNode(Reader reader) {
        StringBuffer sb = new StringBuffer();
        if (reader == null) {
            return null;
        }
        BufferedReader bReader = new BufferedReader(reader);
        try {
            try {
                String s = bReader.readLine();
                while (s != null) {
                    sb.append(s);
                    sb.append('\n');
                    s = bReader.readLine();
                }
            }
            catch (IOException e) {
                String string = null;
                try {
                    bReader.close();
                }
                catch (IOException e2) {
                    return null;
                }
                return string;
            }
        }
        finally {
            try {
                bReader.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(Reader r, int line, int padLines) {
        String text = "";
        try {
            r = new BufferedReader(r);
            int firstLine = Math.max(0, line - padLines);
            int lastLine = line + padLines;
            String aLine = ((BufferedReader)r).readLine();
            for (int curLine = 0; aLine != null && curLine <= lastLine; ++curLine) {
                if (curLine >= firstLine && curLine <= lastLine) {
                    if (curLine > firstLine) {
                        text = text + "\n";
                    }
                    text = text + aLine;
                }
                aLine = ((BufferedReader)r).readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return text;
    }
}

